/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.event;

import com.hbm_m.hazard.HazardSystem;
import com.hbm_m.hazard.HazardType;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class HazardTooltipHandler {
    private static final DecimalFormat df = new DecimalFormat("#.###");

    public static void appendHazardTooltips(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41619_()) {
            return;
        }
        for (HazardType type : HazardType.values()) {
            float level = HazardSystem.getHazardLevelFromStack(stack, type);
            if (!(level > 0.0f)) continue;
            tooltip.add((Component)Component.m_237115_((String)type.getTranslationKey()).m_130940_(type.getColor()));
            if (!type.shouldShowValueInTooltip()) continue;
            tooltip.add((Component)Component.m_237110_((String)type.getFormatTranslationKey(), (Object[])new Object[]{df.format(level)}).m_130940_(ChatFormatting.YELLOW));
            int count = stack.m_41613_();
            if (count <= 1) continue;
            float total = level * (float)count;
            tooltip.add((Component)Component.m_237110_((String)"hazard.hbm_m.stack", (Object[])new Object[]{Component.m_237110_((String)type.getFormatTranslationKey(), (Object[])new Object[]{df.format(total)})}).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

