/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.hazard;

import com.hbm_m.hazard.HazardData;
import com.hbm_m.hazard.HazardEntry;
import com.hbm_m.hazard.HazardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class HazardSystem {
    private static final Map<TagKey<Item>, HazardData> TAG_RULES = new ConcurrentHashMap<TagKey<Item>, HazardData>();
    private static final Map<Item, HazardData> ITEM_RULES = new ConcurrentHashMap<Item, HazardData>();
    private static final Map<Item, Float> ARMOR_PROTECTION_RULES = new ConcurrentHashMap<Item, Float>();
    private static final Map<Item, List<HazardEntry>> HAZARD_CACHE = new ConcurrentHashMap<Item, List<HazardEntry>>();

    private HazardSystem() {
    }

    public static void register(TagKey<Item> tag, HazardData data) {
        TAG_RULES.put(tag, data);
    }

    public static void register(Item item, HazardData data) {
        ITEM_RULES.put(item, data);
    }

    public static void register(Block block, HazardData data) {
        HazardSystem.register(block.m_5456_(), data);
    }

    public static void registerArmorProtection(Item armorItem, float absoluteProtection) {
        ARMOR_PROTECTION_RULES.put(armorItem, Float.valueOf(absoluteProtection));
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return Collections.emptyList();
        }
        Item item = stack.m_41720_();
        if (HAZARD_CACHE.containsKey(item)) {
            return HAZARD_CACHE.get(item);
        }
        ArrayList<HazardData> applicableData = new ArrayList<HazardData>();
        stack.m_204131_().forEach(tag -> {
            if (TAG_RULES.containsKey(tag)) {
                applicableData.add(TAG_RULES.get(tag));
            }
        });
        if (ITEM_RULES.containsKey(item)) {
            applicableData.add(ITEM_RULES.get(item));
        }
        if (applicableData.isEmpty()) {
            HAZARD_CACHE.put(item, Collections.emptyList());
            return Collections.emptyList();
        }
        ArrayList<HazardEntry> finalEntries = new ArrayList<HazardEntry>();
        int mutex = 0;
        for (HazardData data : applicableData) {
            if (data.doesOverride) {
                finalEntries.clear();
                mutex = 0;
            }
            if ((data.getMutex() & mutex) != 0) continue;
            finalEntries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        HAZARD_CACHE.put(item, finalEntries);
        return finalEntries;
    }

    public static float getHazardLevelFromStack(ItemStack stack, HazardType type) {
        List<HazardEntry> entries = HazardSystem.getHazardsFromStack(stack);
        if (entries == null || entries.isEmpty()) {
            return 0.0f;
        }
        for (HazardEntry entry : entries) {
            if (entry.type != type) continue;
            return entry.baseLevel;
        }
        return 0.0f;
    }

    public static float getHazardLevelFromState(BlockState state, HazardType type) {
        if (state.m_60795_() || state.m_60734_().m_5456_() == Items.f_41852_) {
            return 0.0f;
        }
        return HazardSystem.getHazardLevelFromStack(new ItemStack((ItemLike)state.m_60734_()), type);
    }

    public static float getArmorProtection(ItemStack armorStack) {
        if (armorStack.m_41619_()) {
            return 0.0f;
        }
        return ARMOR_PROTECTION_RULES.getOrDefault(armorStack.m_41720_(), Float.valueOf(0.0f)).floatValue();
    }
}

