/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.LongEnergyWrapper;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.item.ModBatteryItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeBattery
extends ModBatteryItem {
    public ItemCreativeBattery(Item.Properties pProperties) {
        super(pProperties.m_41497_(Rarity.EPIC).m_41487_(1), Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void m_7373_(@Nonnull ItemStack pStack, @Nullable Level pLevel, @Nonnull List<Component> pTooltipComponents, @Nonnull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.hbm_m.creative_battery_desc").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.hbm_m.creative_battery_flavor").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
    }

    @Override
    public boolean m_142522_(@Nonnull ItemStack pStack) {
        return false;
    }

    @Override
    public int m_142158_(@Nonnull ItemStack pStack) {
        return 13;
    }

    @Override
    public int m_142159_(@Nonnull ItemStack pStack) {
        return 0xFF00FF;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CreativeEnergyProvider();
    }

    private static class CreativeEnergyProvider
    implements ICapabilityProvider {
        private final LazyOptional<IEnergyProvider> lazyProvider = LazyOptional.of(CreativeEnergyStorage::new);

        private CreativeEnergyProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ModCapabilities.HBM_ENERGY_PROVIDER) {
                return this.lazyProvider.cast();
            }
            if (cap == ForgeCapabilities.ENERGY) {
                return this.lazyProvider.lazyMap(p -> new LongEnergyWrapper((IEnergyConnector)p, LongEnergyWrapper.BitMode.LOW)).cast();
            }
            return LazyOptional.empty();
        }

        private static class CreativeEnergyStorage
        implements IEnergyProvider {
            private CreativeEnergyStorage() {
            }

            @Override
            public long extractEnergy(long maxExtract, boolean simulate) {
                return maxExtract;
            }

            @Override
            public long getEnergyStored() {
                return Long.MAX_VALUE;
            }

            @Override
            public long getMaxEnergyStored() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setEnergyStored(long energy) {
            }

            @Override
            public long getProvideSpeed() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean canExtract() {
                return true;
            }

            @Override
            public boolean canConnectEnergy(Direction side) {
                return true;
            }
        }
    }
}

