/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.api.energy.EnergyCapabilityProvider;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.util.EnergyFormatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ModBatteryItem
extends Item {
    protected final long capacity;
    protected final long maxReceive;
    protected final long maxExtract;

    public ModBatteryItem(Item.Properties properties, long capacity, long maxReceive, long maxExtract) {
        super(properties.m_41487_(1));
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public ModBatteryItem(Item.Properties properties, long capacity, long maxExtract) {
        this(properties, capacity, maxExtract, maxExtract);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyCapabilityProvider(stack, this.capacity, this.maxReceive, this.maxExtract);
    }

    public static void setEnergy(ItemStack stack, long energy) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ModBatteryItem)) {
            return;
        }
        ModBatteryItem battery = (ModBatteryItem)item;
        long clampedEnergy = Math.max(0L, Math.min(energy, battery.getCapacity()));
        stack.m_41784_().m_128356_("energy", clampedEnergy);
    }

    public static long getEnergy(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0L;
        }
        return stack.m_41783_().m_128454_("energy");
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return stack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).map(energy -> {
            if (energy.getMaxEnergyStored() <= 0L) {
                return 0;
            }
            return (int)Math.round(13.0 * (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored());
        }).orElseGet(() -> stack.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).map(energy -> {
            if (energy.getMaxEnergyStored() <= 0L) {
                return 0;
            }
            return (int)Math.round(13.0 * (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored());
        }).orElse(0));
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        float ratio = stack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).map(energy -> {
            if (energy.getMaxEnergyStored() <= 0L) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored());
        }).orElseGet(() -> stack.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).map(energy -> {
            if (energy.getMaxEnergyStored() <= 0L) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored());
        }).orElse(Float.valueOf(0.0f))).floatValue();
        return Mth.m_14169_((float)(ratio / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        stack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).ifPresent(energy -> this.addEnergyTooltip(tooltip, energy.getEnergyStored(), energy.getMaxEnergyStored(), ChatFormatting.AQUA));
        if (!stack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).isPresent()) {
            stack.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).ifPresent(energy -> this.addEnergyTooltip(tooltip, energy.getEnergyStored(), energy.getMaxEnergyStored(), ChatFormatting.AQUA));
        }
        if (this.maxReceive > 0L) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.battery.transfer_rate", (Object[])new Object[]{EnergyFormatter.format(this.maxReceive)}).m_130940_(ChatFormatting.GOLD));
        }
        if (this.maxExtract > 0L) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.battery.discharge_rate", (Object[])new Object[]{EnergyFormatter.format(this.maxExtract)}).m_130940_(ChatFormatting.GOLD));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    private void addEnergyTooltip(List<Component> tooltip, long stored, long max, ChatFormatting color) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.battery.stored").m_130940_(color));
        tooltip.add((Component)Component.m_237113_((String)String.format(" %s / %s HE", EnergyFormatter.format(stored), EnergyFormatter.format(max))).m_130940_(color));
    }
}

