/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item.tools;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DetonatorItem
extends Item {
    private static final String NBT_POS_X = "DetPosX";
    private static final String NBT_POS_Y = "DetPosY";
    private static final String NBT_POS_Z = "DetPosZ";
    private static final String NBT_HAS_TARGET = "HasTarget";

    public DetonatorItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128441_(NBT_HAS_TARGET) && nbt.m_128471_(NBT_HAS_TARGET)) {
                int x = nbt.m_128451_(NBT_POS_X);
                int y = nbt.m_128451_(NBT_POS_Y);
                int z = nbt.m_128451_(NBT_POS_Z);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.target").m_7220_((Component)Component.m_237113_((String)(x + ", " + y + ", " + z))).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.right_click").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.shift_right_click").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.no_target").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.shift_right_click").m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.no_target").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detonator.shift_right_click").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag nbt = stack.m_41783_();
            nbt.m_128405_(NBT_POS_X, pos.m_123341_());
            nbt.m_128405_(NBT_POS_Y, pos.m_123342_());
            nbt.m_128405_(NBT_POS_Z, pos.m_123343_());
            nbt.m_128379_(NBT_HAS_TARGET, true);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430: " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_())).m_130940_(ChatFormatting.GREEN), true);
                if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                    SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            if (!stack.m_41782_()) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u041d\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438!").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            CompoundTag nbt = stack.m_41783_();
            if (!nbt.m_128441_(NBT_HAS_TARGET) || !nbt.m_128471_(NBT_HAS_TARGET)) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u041d\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438!").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            int x = nbt.m_128451_(NBT_POS_X);
            int y = nbt.m_128451_(NBT_POS_Y);
            int z = nbt.m_128451_(NBT_POS_Z);
            BlockPos targetPos = new BlockPos(x, y, z);
            if (!level.f_46443_) {
                if (!level.m_46749_(targetPos)) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0438\u043b\u0438 \u043d\u0435 \u043f\u0440\u043e\u0433\u0440\u0443\u0436\u0435\u043d\u0430").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                BlockState state = level.m_8055_(targetPos);
                Block block = state.m_60734_();
                if (block instanceof IDetonatable) {
                    IDetonatable detonatable = (IDetonatable)block;
                    boolean success = detonatable.onDetonate(level, targetPos, state, player);
                    if (success) {
                        player.m_5661_((Component)Component.m_237113_((String)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e").m_130940_(ChatFormatting.GREEN), true);
                        if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                            SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                        }
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    player.m_5661_((Component)Component.m_237113_((String)"\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0438\u043b\u0438 \u043d\u0435 \u043f\u0440\u043e\u0433\u0440\u0443\u0436\u0435\u043d\u0430").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                player.m_5661_((Component)Component.m_237113_((String)"\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430 \u0438\u043b\u0438 \u043d\u0435 \u043f\u0440\u043e\u0433\u0440\u0443\u0436\u0435\u043d\u0430").m_130940_(ChatFormatting.RED), true);
                if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                    SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

