/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item.tools;

import com.hbm_m.item.AbstractRadiationMeterItem;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.sounds.GeigerSoundPacket;
import com.hbm_m.sound.ModSounds;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class ItemDosimeter
extends AbstractRadiationMeterItem {
    private static final Random RANDOM = new Random();
    private int soundTickCounter = 0;

    public ItemDosimeter(Item.Properties pProperties) {
        super(pProperties);
    }

    private String getDosimeterRadColor(float rads) {
        if (rads == 0.0f) {
            return "\u00a7a";
        }
        return "\u00a76";
    }

    @Override
    @Nonnull
    protected Component createUsageMessage(AbstractRadiationMeterItem.RadiationData data) {
        float totalEnvironmentRad = data.getTotalEnvironmentRad();
        String colorCode = this.getDosimeterRadColor(totalEnvironmentRad);
        String envRadStr = totalEnvironmentRad < 3.6f ? colorCode + String.format("%.1f RAD/s", Float.valueOf(totalEnvironmentRad)) : colorCode + Component.m_237110_((String)"item.hbm_m.meter.rads_over_limit", (Object[])new Object[]{"3.6"}).getString();
        String titleString = "\n\u00a76===== \u2622 " + Component.m_237115_((String)"item.hbm_m.meter.dosimeter.name").getString() + " \u2622 =====\n";
        MutableComponent message = Component.m_237110_((String)"item.hbm_m.meter.title_format", (Object[])new Object[]{titleString});
        message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.env_rads", (Object[])new Object[]{envRadStr}));
        return message;
    }

    public void m_6883_(@Nonnull ItemStack pStack, @Nonnull Level pLevel, @Nonnull Entity pEntity, int pSlotId, boolean pIsSelected) {
        ServerPlayer serverPlayer;
        if (!pLevel.m_5776_() && pEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)pEntity).m_6084_()) {
            ++this.soundTickCounter;
            int SOUND_INTERVAL_TICKS = 5;
            if (this.soundTickCounter >= 5) {
                this.soundTickCounter = 0;
                AbstractRadiationMeterItem.RadiationData data = this.measureRadiation(pLevel, (Player)serverPlayer);
                float totalEnvironmentRads = data.getTotalEnvironmentRad();
                this.playDosimeterTickSound(serverPlayer, totalEnvironmentRads);
            }
        }
    }

    private void playDosimeterTickSound(ServerPlayer player, float radiationLevel) {
        int soundIndex = 0;
        ArrayList<Integer> soundOptions = new ArrayList<Integer>();
        if (radiationLevel > 0.0f) {
            if (radiationLevel < 10.0f) {
                soundOptions.add(1);
            }
            if (radiationLevel > 5.0f) {
                soundOptions.add(2);
            }
            if (radiationLevel > 15.0f) {
                soundOptions.add(3);
            }
            if (!soundOptions.isEmpty()) {
                soundIndex = (Integer)soundOptions.get(RANDOM.nextInt(soundOptions.size()));
            }
        } else if (RANDOM.nextInt(50) == 0) {
            soundIndex = 1;
        }
        Optional<Object> soundRegistryObject = switch (soundIndex) {
            case 1 -> Optional.of(ModSounds.GEIGER_1);
            case 2 -> Optional.of(ModSounds.GEIGER_2);
            case 3 -> Optional.of(ModSounds.GEIGER_3);
            default -> Optional.empty();
        };
        soundRegistryObject.ifPresent(regObject -> {
            SoundEvent soundEvent = (SoundEvent)regObject.get();
            if (soundEvent != null) {
                ResourceLocation soundLocation = soundEvent.m_11660_();
                ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GeigerSoundPacket(soundLocation, 0.4f, 1.0f));
            }
        });
    }
}

