/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item.tools;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MultiDetonatorItem
extends Item {
    private static final String NBT_ACTIVE_POINT = "ActivePoint";
    private static final String NBT_POINTS_TAG = "Points";
    private static final String NBT_POINT_X = "X";
    private static final String NBT_POINT_Y = "Y";
    private static final String NBT_POINT_Z = "Z";
    private static final String NBT_POINT_NAME = "Name";
    private static final String NBT_POINT_HAS_TARGET = "HasTarget";
    private static final int MAX_POINTS = 4;
    private static final int MAX_NAME_LENGTH = 16;

    public MultiDetonatorItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        for (int i = 0; i < 4; ++i) {
            PointData point = this.getPointData(stack, i);
            if (point != null && point.hasTarget) {
                if (i == this.getActivePoint(stack)) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.multi_detonator.active_point", (Object[])new Object[]{point.name}).m_130940_(ChatFormatting.YELLOW));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.multi_detonator.point_set", (Object[])new Object[]{point.name}).m_130940_(ChatFormatting.GREEN));
                }
                tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.multi_detonator.coordinates", (Object[])new Object[]{point.x, point.y, point.z}).m_130940_(ChatFormatting.WHITE));
                continue;
            }
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.multi_detonator.point_empty", (Object[])new Object[]{i + 1}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.multi_detonator.not_set").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.multi_detonator.key_r").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.multi_detonator.shift_rmb").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.multi_detonator.rmb_activate").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            CompoundTag nbt;
            int activePoint;
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            if ((activePoint = (nbt = stack.m_41783_()).m_128451_(NBT_ACTIVE_POINT)) < 0 || activePoint >= 4) {
                activePoint = 0;
            }
            if (!nbt.m_128425_(NBT_POINTS_TAG, 9)) {
                nbt.m_128365_(NBT_POINTS_TAG, (Tag)new ListTag());
            }
            ListTag pointsList = nbt.m_128437_(NBT_POINTS_TAG, 10);
            while (pointsList.size() <= activePoint) {
                CompoundTag newPointTag = MultiDetonatorItem.createEmptyPointTag();
                pointsList.add((Object)newPointTag);
            }
            CompoundTag pointTag = pointsList.m_128728_(activePoint);
            String savedName = pointTag.m_128461_(NBT_POINT_NAME);
            pointTag.m_128405_(NBT_POINT_X, pos.m_123341_());
            pointTag.m_128405_(NBT_POINT_Y, pos.m_123342_());
            pointTag.m_128405_(NBT_POINT_Z, pos.m_123343_());
            pointTag.m_128379_(NBT_POINT_HAS_TARGET, true);
            pointTag.m_128359_(NBT_POINT_NAME, (String)(savedName.isEmpty() ? "Point " + (activePoint + 1) : savedName));
            pointsList.set(activePoint, (Tag)pointTag);
            nbt.m_128365_(NBT_POINTS_TAG, (Tag)pointsList);
            if (!level.f_46443_) {
                String finalName = pointTag.m_128461_(NBT_POINT_NAME);
                player.m_5661_((Component)Component.m_237110_((String)"message.hbm_m.multi_detonator.position_saved", (Object[])new Object[]{finalName, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GREEN), true);
                if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                    SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        block16: {
            stack = player.m_21120_(hand);
            if (player.m_6047_()) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (!level.f_46443_) {
                PointData pointData;
                if (!stack.m_41782_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.multi_detonator.no_coordinates").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                CompoundTag nbt = stack.m_41783_();
                int activePoint = nbt.m_128451_(NBT_ACTIVE_POINT);
                if (activePoint >= 4) {
                    activePoint = 0;
                }
                if ((pointData = this.getPointData(stack, activePoint)) == null || !pointData.hasTarget) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.hbm_m.multi_detonator.point_not_set", (Object[])new Object[]{activePoint + 1}).m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                BlockPos targetPos = new BlockPos(pointData.x, pointData.y, pointData.z);
                if (!level.m_46749_(targetPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.multi_detonator.chunk_not_loaded").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                BlockState state = level.m_8055_(targetPos);
                Block block = state.m_60734_();
                if (block instanceof IDetonatable) {
                    IDetonatable detonatable = (IDetonatable)block;
                    try {
                        boolean success = detonatable.onDetonate(level, targetPos, state, player);
                        if (!success) break block16;
                        player.m_5661_((Component)Component.m_237110_((String)"message.hbm_m.multi_detonator.activated", (Object[])new Object[]{pointData.name}).m_130940_(ChatFormatting.GREEN), true);
                        if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                            SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    catch (Exception e) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.multi_detonator.activation_error").m_130940_(ChatFormatting.RED), true);
                        if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                            SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                        }
                        e.printStackTrace();
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.multi_detonator.incompatible_block").m_130940_(ChatFormatting.RED), true);
                    if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public PointData getPointData(ItemStack stack, int pointIndex) {
        if (!stack.m_41782_() || pointIndex < 0 || pointIndex >= 4) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128425_(NBT_POINTS_TAG, 9)) {
            return null;
        }
        ListTag pointsList = nbt.m_128437_(NBT_POINTS_TAG, 10);
        if (pointIndex >= pointsList.size()) {
            return null;
        }
        CompoundTag pointTag = pointsList.m_128728_(pointIndex);
        if (pointTag.m_128456_()) {
            return null;
        }
        Object name = pointTag.m_128461_(NBT_POINT_NAME);
        if (((String)name).isEmpty()) {
            name = "Point " + (pointIndex + 1);
        }
        return new PointData(pointTag.m_128451_(NBT_POINT_X), pointTag.m_128451_(NBT_POINT_Y), pointTag.m_128451_(NBT_POINT_Z), (String)name, pointTag.m_128471_(NBT_POINT_HAS_TARGET));
    }

    public void setActivePoint(ItemStack stack, int pointIndex) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag nbt = stack.m_41783_();
        if (pointIndex >= 0 && pointIndex < 4) {
            nbt.m_128405_(NBT_ACTIVE_POINT, pointIndex);
        }
    }

    public int getActivePoint(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        int activePoint = stack.m_41783_().m_128451_(NBT_ACTIVE_POINT);
        return activePoint >= 0 && activePoint < 4 ? activePoint : 0;
    }

    public void setPointName(ItemStack stack, int pointIndex, String name) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (pointIndex < 0 || pointIndex >= 4) {
            return;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128425_(NBT_POINTS_TAG, 9)) {
            nbt.m_128365_(NBT_POINTS_TAG, (Tag)new ListTag());
        }
        ListTag pointsList = nbt.m_128437_(NBT_POINTS_TAG, 10);
        while (pointsList.size() <= pointIndex) {
            CompoundTag newPointTag = MultiDetonatorItem.createEmptyPointTag();
            pointsList.add((Object)newPointTag);
        }
        CompoundTag pointTag = pointsList.m_128728_(pointIndex);
        String limitedName = name.length() > 16 ? name.substring(0, 16) : name;
        pointTag.m_128359_(NBT_POINT_NAME, limitedName);
        pointsList.set(pointIndex, (Tag)pointTag);
        nbt.m_128365_(NBT_POINTS_TAG, (Tag)pointsList);
    }

    public void clearPoint(ItemStack stack, int pointIndex) {
        if (!stack.m_41782_() || pointIndex < 0 || pointIndex >= 4) {
            return;
        }
        CompoundTag nbt = stack.m_41783_();
        if (!nbt.m_128425_(NBT_POINTS_TAG, 9)) {
            return;
        }
        ListTag pointsList = nbt.m_128437_(NBT_POINTS_TAG, 10);
        if (pointIndex < pointsList.size()) {
            CompoundTag pointTag = pointsList.m_128728_(pointIndex);
            String savedName = pointTag.m_128461_(NBT_POINT_NAME);
            CompoundTag clearedTag = new CompoundTag();
            clearedTag.m_128405_(NBT_POINT_X, 0);
            clearedTag.m_128405_(NBT_POINT_Y, 0);
            clearedTag.m_128405_(NBT_POINT_Z, 0);
            clearedTag.m_128379_(NBT_POINT_HAS_TARGET, false);
            clearedTag.m_128359_(NBT_POINT_NAME, savedName);
            pointsList.set(pointIndex, (Tag)clearedTag);
            nbt.m_128365_(NBT_POINTS_TAG, (Tag)pointsList);
        }
    }

    public int getMaxPoints() {
        return 4;
    }

    private static CompoundTag createEmptyPointTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(NBT_POINT_X, 0);
        tag.m_128405_(NBT_POINT_Y, 0);
        tag.m_128405_(NBT_POINT_Z, 0);
        tag.m_128359_(NBT_POINT_NAME, "");
        tag.m_128379_(NBT_POINT_HAS_TARGET, false);
        return tag;
    }

    public static class PointData {
        public int x;
        public int y;
        public int z;
        public String name;
        public boolean hasTarget;

        public PointData(int x, int y, int z, String name, boolean hasTarget) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.name = name;
            this.hasTarget = hasTarget;
        }
    }
}

