/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item.tools;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class OilDetectorItem
extends Item {
    public OilDetectorItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, @Nullable List<Component> tooltip, TooltipFlag flag) {
        if (tooltip == null) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.oil_detector.scans_chunks").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.oil_detector.oil_deposits").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos playerPos = player.m_20183_();
        boolean oilUnderPlayer = this.checkColumnUnderPlayer(level, playerPos);
        boolean oilFound = this.scanChunkForOil(level, playerPos);
        boolean oilInAdjacentChunk = this.scanAdjacentChunksForOil(level, playerPos);
        if (oilUnderPlayer) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.oil_detector.directly_below").m_130940_(ChatFormatting.DARK_GREEN), true);
            if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
            }
        } else if (oilFound) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.oil_detector.in_chunk").m_130940_(ChatFormatting.GREEN), true);
            if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
            }
        } else if (oilInAdjacentChunk) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.oil_detector.adjacent_chunk").m_130940_(ChatFormatting.GOLD), true);
            if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.oil_detector.none_found").m_130940_(ChatFormatting.RED), true);
            if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void playSound(Level level, Player player, Optional<SoundEvent> sound) {
        sound.ifPresent(soundEvent -> level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f));
    }

    private boolean scanChunkForOil(Level level, BlockPos playerPos) {
        int chunkX = playerPos.m_123341_() >> 4;
        int chunkZ = playerPos.m_123343_() >> 4;
        int minX = chunkX << 4;
        int maxX = minX + 15;
        int minZ = chunkZ << 4;
        int maxZ = minZ + 15;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = level.m_141937_(); y <= level.m_151558_(); ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isOilBlock(level, pos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean scanAdjacentChunksForOil(Level level, BlockPos playerPos) {
        int chunkX = playerPos.m_123341_() >> 4;
        int chunkZ = playerPos.m_123343_() >> 4;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                int currentChunkX = chunkX + dx;
                int currentChunkZ = chunkZ + dz;
                int minX = currentChunkX << 4;
                int maxX = minX + 15;
                int minZ = currentChunkZ << 4;
                int maxZ = minZ + 15;
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        for (int y = level.m_141937_(); y <= level.m_151558_(); ++y) {
                            BlockPos pos = new BlockPos(x, y, z);
                            if (!this.isOilBlock(level, pos)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean checkColumnUnderPlayer(Level level, BlockPos playerPos) {
        int x = playerPos.m_123341_();
        int z = playerPos.m_123343_();
        for (int y = level.m_141937_(); y <= level.m_151558_(); ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!this.isOilBlock(level, pos)) continue;
            return true;
        }
        return false;
    }

    private boolean isOilBlock(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        return block == ModBlocks.ORE_OIL.get();
    }
}

