/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item.tools;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class RangeDetonatorItem
extends Item {
    private static final int MAX_RANGE = 256;

    public RangeDetonatorItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && (hitResult = (BlockHitResult)player.m_19907_(256.0, 1.0f, false)).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos targetPos = hitResult.m_82425_();
            if (!level.m_46749_(targetPos)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.range_detonator.pos_not_loaded").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            this.spawnRedstoneParticles(level, targetPos);
            BlockState state = level.m_8055_(targetPos);
            Block block = state.m_60734_();
            if (block instanceof IDetonatable) {
                IDetonatable detonatable = (IDetonatable)block;
                boolean success = detonatable.onDetonate(level, targetPos, state, player);
                if (success) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.range_detonator.activated").m_130940_(ChatFormatting.GREEN), true);
                    if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                        SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.range_detonator.pos_not_loaded").m_130940_(ChatFormatting.RED), true);
                if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                    SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.range_detonator.pos_not_loaded").m_130940_(ChatFormatting.RED), true);
            if (ModSounds.TOOL_TECH_BOOP.isPresent()) {
                SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void spawnRedstoneParticles(Level level, BlockPos pos) {
        for (int i = 0; i < 8; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.2;
            double offsetY = (Math.random() - 0.5) * 0.2;
            double offsetZ = (Math.random() - 0.5) * 0.2;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.range_detonator.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.range_detonator.hint").m_130940_(ChatFormatting.GRAY));
    }
}

