/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.AnvilBlockEntity;
import com.hbm_m.menu.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class AnvilMenu
extends AbstractContainerMenu {
    public final AnvilBlockEntity blockEntity;
    private final Level level;
    private final ContainerLevelAccess access;

    public AnvilMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, extraData.m_130135_());
    }

    private AnvilMenu(int containerId, Inventory inv, BlockPos pos) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(pos));
    }

    public AnvilMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)ModMenuTypes.ANVIL_MENU.get(), containerId);
        AnvilBlockEntity anvilEntity;
        this.blockEntity = entity instanceof AnvilBlockEntity ? (anvilEntity = (AnvilBlockEntity)entity) : new AnvilBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.ANVIL_IRON.get()).m_49966_());
        this.level = inv.f_35978_.m_9236_();
        this.access = ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_());
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemStackHandler itemHandler = this.blockEntity.getItemHandler();
        this.m_38897_((Slot)new SmithingInputSlot((IItemHandler)itemHandler, 0, 17, 27));
        this.m_38897_((Slot)new SmithingInputSlot((IItemHandler)itemHandler, 1, 53, 27));
        this.m_38897_((Slot)new SmithingOutputSlot((IItemHandler)itemHandler, 2, 89, 27));
    }

    public void tryCraft(Player player, boolean craftAll) {
        this.blockEntity.craft(player, craftAll);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index == 38) {
            if (!this.m_38903_(sourceStack, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_40234_(sourceStack, copyOfSourceStack);
        } else if (index >= 36 && index <= 37 ? !this.m_38903_(sourceStack, 0, 36, false) : !this.m_38903_(sourceStack, 36, 38, false) && (index < 27 ? !this.m_38903_(sourceStack, 27, 36, false) : index < 36 && !this.m_38903_(sourceStack, 0, 27, false))) {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_269060_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        if (sourceStack.m_41613_() == copyOfSourceStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return AnvilMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, pos) -> {
            if (!level.f_46443_) {
                ItemStackHandler handler = this.blockEntity.getItemHandler();
                for (int i = 0; i < 2; ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    ItemStack toReturn = stack.m_41777_();
                    handler.setStackInSlot(i, ItemStack.f_41583_);
                    if (!player.m_150109_().m_36054_(toReturn)) {
                        player.m_36176_(toReturn, false);
                        continue;
                    }
                    if (toReturn.m_41619_()) continue;
                    player.m_36176_(toReturn, false);
                }
                handler.setStackInSlot(2, ItemStack.f_41583_);
            }
        });
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18 + 56));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 198));
        }
    }

    private class SmithingInputSlot
    extends SlotItemHandler {
        public SmithingInputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void m_6654_() {
            super.m_6654_();
            AnvilMenu.this.blockEntity.updateCrafting();
        }

        public void m_5852_(@NotNull ItemStack stack) {
            super.m_5852_(stack);
            AnvilMenu.this.blockEntity.updateCrafting();
        }

        @NotNull
        public ItemStack m_6201_(int amount) {
            ItemStack result = super.m_6201_(amount);
            AnvilMenu.this.blockEntity.updateCrafting();
            return result;
        }
    }

    private class SmithingOutputSlot
    extends SlotItemHandler {
        public SmithingOutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
            super.m_142406_(player, stack);
            if (!AnvilMenu.this.level.f_46443_) {
                AnvilMenu.this.blockEntity.handleCombineOutputTaken(player, stack);
            }
        }

        public void m_6654_() {
            super.m_6654_();
            AnvilMenu.this.blockEntity.updateCrafting();
        }
    }
}

