/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.machine.MachineAssemblerBlockEntity;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.util.LongDataPacker;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MachineAssemblerMenu
extends AbstractContainerMenu {
    private final MachineAssemblerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 18;

    public MachineAssemblerMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(9));
    }

    public MachineAssemblerMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.MACHINE_ASSEMBLER_MENU.get(), pContainerId);
        MachineAssemblerMenu.m_38869_((Container)inv, (int)18);
        this.blockEntity = (MachineAssemblerBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 80, 18){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
                }
            });
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 152, 18));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 152, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 152, 54));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 80, 54){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_41720_() instanceof ItemAssemblyTemplate;
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 134, 90){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return false;
                }
            });
            for (int row = 0; row < 6; ++row) {
                for (int col = 0; col < 2; ++col) {
                    int slotIndex = 6 + row * 2 + col;
                    int x = 8 + col * 18;
                    int y = 18 + row * 18;
                    this.m_38897_((Slot)new SlotItemHandler(handler, slotIndex, x, y));
                }
            }
        });
        this.m_38884_(data);
    }

    public long getEnergyLong() {
        return LongDataPacker.unpack(this.data.m_6413_(2), this.data.m_6413_(3));
    }

    public long getMaxEnergyLong() {
        return LongDataPacker.unpack(this.data.m_6413_(4), this.data.m_6413_(5));
    }

    public boolean isCrafting() {
        return this.data.m_6413_(8) > 0;
    }

    public long getEnergyDeltaLong() {
        return LongDataPacker.unpack(this.data.m_6413_(6), this.data.m_6413_(7));
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.data.m_6413_(1);
    }

    public MachineAssemblerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getProgressScaled(int width) {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        return maxProgress != 0 && progress != 0 ? progress * width / maxProgress : 0;
    }

    public int getEnergyScaled(int height) {
        long energy = this.getEnergyLong();
        long maxEnergy = this.getMaxEnergyLong();
        return maxEnergy != 0L ? (int)(energy * (long)height / maxEnergy) : 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    @NotNull
    public ItemStack m_7648_(@Nonnull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            boolean moved = false;
            if (sourceStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                moved = this.m_38903_(sourceStack, 36, 37, false);
            }
            if (!moved && sourceStack.m_41720_() instanceof ItemAssemblyTemplate) {
                moved = this.m_38903_(sourceStack, 40, 41, false);
            }
            if (!moved) {
                moved = this.m_38903_(sourceStack, 42, 54, false);
            }
            if (!moved && !this.m_38903_(sourceStack, 36, 54, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 54) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            MainRegistry.LOGGER.debug("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@Nonnull Player pPlayer) {
        return MachineAssemblerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.MACHINE_ASSEMBLER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 140 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }
}

