/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.machine.MachinePressBlockEntity;
import com.hbm_m.item.ItemStamp;
import com.hbm_m.item.ModItems;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MachinePressMenu
extends AbstractContainerMenu {
    public final MachinePressBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 4;

    public MachinePressMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(9));
    }

    public MachinePressMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.PRESS_MENU.get(), containerId);
        MachinePressMenu.m_38869_((Container)inv, (int)4);
        this.blockEntity = (MachinePressBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new FuelSlot((IItemHandler)iItemHandler, 0, 26, 53));
            this.m_38897_((Slot)new StampSlot((IItemHandler)iItemHandler, 1, 80, 17));
            this.m_38897_((Slot)new MaterialSlot((IItemHandler)iItemHandler, 2, 80, 53));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)iItemHandler, 3, 139, 34));
        });
        this.m_38884_(data);
    }

    public int getPress() {
        return this.data.m_6413_(0);
    }

    public int getMaxPress() {
        return this.data.m_6413_(1);
    }

    public int getBurnTime() {
        return this.data.m_6413_(2);
    }

    public int getFuelPerOperation() {
        return this.data.m_6413_(3);
    }

    public int getSpeed() {
        return this.data.m_6413_(4);
    }

    public int getMaxSpeed() {
        return this.data.m_6413_(5);
    }

    public int getHeatState() {
        return this.data.m_6413_(6);
    }

    public int getPressPosition() {
        return this.data.m_6413_(7);
    }

    public boolean isRetracting() {
        return this.data.m_6413_(8) == 1;
    }

    public boolean isCrafting() {
        return this.getPress() > 0 || this.isRetracting();
    }

    public boolean isHeated() {
        return this.getBurnTime() >= this.getFuelPerOperation();
    }

    public boolean isBurning() {
        return this.getBurnTime() >= 20;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 40) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            MainRegistry.LOGGER.debug("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return MachinePressMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.PRESS.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private static class FuelSlot
    extends SlotItemHandler {
        public FuelSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item == ModItems.LIGNITE.get()) {
                return true;
            }
            return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
        }
    }

    private static class StampSlot
    extends SlotItemHandler {
        public StampSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_41720_() instanceof ItemStamp) {
                return true;
            }
            return stack.m_41720_().toString().contains("stamp");
        }
    }

    private static class MaterialSlot
    extends SlotItemHandler {
        public MaterialSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            String itemName = stack.m_41720_().toString();
            return itemName.contains("ingot") || itemName.contains("metal");
        }
    }

    private static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

