/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.machine.MachineShredderBlockEntity;
import com.hbm_m.item.ItemBlades;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.util.LongDataPacker;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MachineShredderMenu
extends AbstractContainerMenu {
    private final MachineShredderBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int INPUT_SLOTS = 9;
    private static final int OUTPUT_SLOTS = 18;
    private static final int BLADE_SLOTS = 2;
    private static final int BATTERY_SLOT = 29;
    private static final int BLADE_LEFT = 27;
    private static final int BLADE_RIGHT = 28;

    public MachineShredderMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, MachineShredderMenu.getBlockEntity(playerInventory, extraData), (ContainerData)new SimpleContainerData(8));
    }

    public MachineShredderMenu(int containerId, Inventory playerInventory, MachineShredderBlockEntity blockEntity) {
        this(containerId, playerInventory, blockEntity, blockEntity.getContainerData());
    }

    public MachineShredderMenu(int containerId, Inventory playerInventory, MachineShredderBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.SHREDDER_MENU.get(), containerId);
        int col;
        this.blockEntity = blockEntity;
        this.level = playerInventory.f_35978_.m_9236_();
        this.data = data;
        this.m_38884_(data);
        ItemStackHandler itemHandler = this.blockEntity.getInventory();
        int startX = 44;
        int startY = 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 3; ++col2) {
                int index = row * 3 + col2;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, index, startX + col2 * 18, startY + row * 18));
            }
        }
        int outputX = 116;
        int outputY = 18;
        for (int col3 = 0; col3 < 6; ++col3) {
            for (int row = 0; row < 3; ++row) {
                int index = col3 * 3 + row;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 9 + index, outputX + row * 18, outputY + col3 * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }
                });
            }
        }
        int bladeX = 44;
        int bladeY = 108;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 27, bladeX, bladeY));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 28, bladeX + 36, bladeY));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 29, 8, 108){

            public boolean m_5857_(ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }
        });
        int playerInvX = 8;
        int playerInvY = 151;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, playerInvX + col * 18, playerInvY + row * 18));
            }
        }
        int hotbarY = 209;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, playerInvX + col * 18, hotbarY));
        }
    }

    private static MachineShredderBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntity instanceof MachineShredderBlockEntity) {
            MachineShredderBlockEntity shredder = (MachineShredderBlockEntity)blockEntity;
            return shredder;
        }
        throw new IllegalStateException("BlockEntity is not a MachineShredder");
    }

    public ItemStack m_7648_(Player player, int index) {
        int containerSlots;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = slot.m_7993_();
        itemstack = slotStack.m_41777_();
        int playerInventoryStart = containerSlots = 30;
        int playerInventoryEnd = this.f_38839_.size();
        if (index < containerSlots) {
            if (!this.m_38903_(slotStack, playerInventoryStart, playerInventoryEnd, true)) {
                return ItemStack.f_41583_;
            }
        } else if (index >= playerInventoryStart && index < playerInventoryEnd) {
            boolean isBlade = slotStack.m_41720_() instanceof ItemBlades;
            boolean isBattery = slotStack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            boolean moved = false;
            if (isBattery) {
                moved = this.m_38903_(slotStack, 29, 30, false);
            }
            if (!moved && isBlade) {
                moved = this.m_38903_(slotStack, 27, 29, false);
            }
            if (!moved) {
                moved = this.m_38903_(slotStack, 0, 9, false);
            }
            if (!moved) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (slotStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, slotStack);
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return MachineShredderMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.SHREDDER.get()));
    }

    public MachineShredderBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.data.m_6413_(1);
    }

    public int getScaledProgress(int width) {
        int progress = this.getProgress();
        int maxProgress = this.getMaxProgress();
        return maxProgress == 0 ? 0 : progress * width / maxProgress;
    }

    public long getEnergyLong() {
        return LongDataPacker.unpack(this.data.m_6413_(2), this.data.m_6413_(3));
    }

    public long getMaxEnergyLong() {
        return LongDataPacker.unpack(this.data.m_6413_(4), this.data.m_6413_(5));
    }

    public long getEnergyDeltaLong() {
        return LongDataPacker.unpack(this.data.m_6413_(6), this.data.m_6413_(7));
    }
}

