/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.machine.MachineWoodBurnerBlockEntity;
import com.hbm_m.menu.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MachineWoodBurnerMenu
extends AbstractContainerMenu {
    public final MachineWoodBurnerBlockEntity blockEntity;
    private final ContainerData data;
    private static final int PLAYER_INV_START = 0;
    private static final int PLAYER_INV_END = 36;
    private static final int FUEL_SLOT = 36;
    private static final int ASH_SLOT = 37;
    private static final int CHARGE_SLOT = 38;

    public MachineWoodBurnerMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public MachineWoodBurnerMenu(int id, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.WOOD_BURNER_MENU.get(), id);
        this.blockEntity = (MachineWoodBurnerBlockEntity)entity;
        this.data = data;
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 0, 26, 18){

                public boolean m_5857_(ItemStack stack) {
                    return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 1, 26, 54){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 2, 143, 54){

                public boolean m_5857_(ItemStack stack) {
                    return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::canReceive).orElse(false);
                }
            });
        });
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (pIndex == 36 || pIndex == 37 || pIndex == 38) {
                if (!this.m_38903_(slotStack, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemstack);
            } else if (pIndex >= 0 && pIndex < 36) {
                if (ForgeHooks.getBurnTime((ItemStack)slotStack, null) > 0 && this.m_38903_(slotStack, 36, 37, false)) {
                    if (slotStack.m_41619_()) {
                        slot.m_5852_(ItemStack.f_41583_);
                    } else {
                        slot.m_6654_();
                    }
                    return itemstack;
                }
                if (slotStack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::canReceive).orElse(false).booleanValue() && this.m_38903_(slotStack, 38, 39, false)) {
                    if (slotStack.m_41619_()) {
                        slot.m_5852_(ItemStack.f_41583_);
                    } else {
                        slot.m_6654_();
                    }
                    return itemstack;
                }
                if (pIndex < 27 ? !this.m_38903_(slotStack, 27, 36, false) : !this.m_38903_(slotStack, 0, 27, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, slotStack);
        }
        return itemstack;
    }

    public long getEnergyLong() {
        return (long)this.data.m_6413_(1) << 32 | (long)this.data.m_6413_(0) & 0xFFFFFFFFL;
    }

    public long getMaxEnergyLong() {
        return (long)this.data.m_6413_(3) << 32 | (long)this.data.m_6413_(2) & 0xFFFFFFFFL;
    }

    public int getBurnTime() {
        return this.data.m_6413_(4);
    }

    public int getMaxBurnTime() {
        return this.data.m_6413_(5);
    }

    public boolean isLit() {
        return this.data.m_6413_(6) != 0;
    }

    public boolean isEnabled() {
        return this.data.m_6413_(7) != 0;
    }

    public int getBurnTimeScaled(int scale) {
        int max = this.getMaxBurnTime();
        return max > 0 ? this.getBurnTime() * scale / max : 0;
    }

    public int getEnergyScaled(int scale) {
        long max = this.getMaxEnergyLong();
        return max > 0L ? (int)((double)this.getEnergyLong() / (double)max * (double)scale) : 0;
    }

    public boolean m_6875_(Player pPlayer) {
        return MachineWoodBurnerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.WOOD_BURNER.get()));
    }

    private void addPlayerInventory(Inventory i) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)i, x + y * 9 + 9, 8 + x * 18, 104 + y * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory i) {
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)i, x, 8 + x * 18, 162));
        }
    }
}

