/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.module.machine;

import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.module.machine.MachineModuleBase;
import com.hbm_m.recipe.AssemblerRecipe;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class MachineModuleAdvancedAssembler
extends MachineModuleBase<AssemblerRecipe> {
    private long energyPerTick = 100L;
    @Nullable
    private AssemblerRecipe preferredRecipe = null;

    public MachineModuleAdvancedAssembler(int moduleIndex, IEnergyReceiver energyStorage, IItemHandler itemHandler, Level level) {
        super(moduleIndex, energyStorage, itemHandler, level);
        this.inputSlots = new int[12];
        for (int i = 0; i < 12; ++i) {
            this.inputSlots[i] = 4 + i;
        }
        this.outputSlots = new int[]{16};
    }

    public MachineModuleAdvancedAssembler setInputSlots(int startSlot, int count) {
        this.inputSlots = new int[count];
        for (int i = 0; i < count; ++i) {
            this.inputSlots[i] = startSlot + i;
        }
        return this;
    }

    public MachineModuleAdvancedAssembler setOutputSlot(int slot) {
        this.outputSlots = new int[]{slot};
        return this;
    }

    public MachineModuleAdvancedAssembler setEnergyPerTick(long energy) {
        this.energyPerTick = energy;
        return this;
    }

    protected AssemblerRecipe.Type getRecipeType() {
        return AssemblerRecipe.Type.INSTANCE;
    }

    @Override
    @Nullable
    public AssemblerRecipe findRecipeForInputs() {
        if (this.level == null) {
            return null;
        }
        if (this.preferredRecipe != null) {
            if (this.matchesRecipe(this.preferredRecipe)) {
                return this.preferredRecipe;
            }
            return null;
        }
        ItemStack blueprint = this.itemHandler.getStackInSlot(1);
        RecipeManager recipeManager = this.level.m_7465_();
        List allRecipes = recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
        for (AssemblerRecipe recipe : allRecipes) {
            if (!this.matchesRecipe(recipe) || !this.isRecipeValidForBlueprint(recipe, blueprint)) continue;
            return recipe;
        }
        return null;
    }

    private boolean matchesRecipe(AssemblerRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        ItemStack[] inputCopy = new ItemStack[this.inputSlots.length];
        for (int i = 0; i < this.inputSlots.length; ++i) {
            inputCopy[i] = this.itemHandler.getStackInSlot(this.inputSlots[i]).m_41777_();
        }
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            for (int i = 0; i < inputCopy.length; ++i) {
                if (inputCopy[i].m_41619_() || !ingredient.test(inputCopy[i])) continue;
                inputCopy[i].m_41774_(1);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setPreferredRecipe(@Nullable AssemblerRecipe recipe) {
        this.preferredRecipe = recipe;
        if (this.currentRecipe != null && recipe != null && !Objects.equals(((AssemblerRecipe)this.currentRecipe).m_6423_(), recipe.m_6423_())) {
            this.resetProgress();
        }
    }

    @Nullable
    public AssemblerRecipe getPreferredRecipe() {
        return this.preferredRecipe;
    }

    @Override
    protected boolean matchesCurrentRecipe(AssemblerRecipe recipe) {
        return this.matchesRecipe(recipe);
    }

    @Override
    public boolean canProcess(AssemblerRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < this.energyPerTick) {
            return false;
        }
        if (!this.matchesRecipe(recipe)) {
            return false;
        }
        ItemStack outputSlot = this.itemHandler.getStackInSlot(this.outputSlots[0]);
        ItemStack result = recipe.m_8043_(this.level.m_9598_());
        if (outputSlot.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)outputSlot, (ItemStack)result)) {
            return false;
        }
        return outputSlot.m_41613_() + result.m_41613_() <= outputSlot.m_41741_();
    }

    @Override
    protected void processCraft(AssemblerRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        block0: for (Ingredient ingredient : ingredients) {
            for (int slot : this.inputSlots) {
                ItemStack stack = this.itemHandler.getStackInSlot(slot);
                if (stack.m_41619_() || !ingredient.test(stack)) continue;
                this.itemHandler.extractItem(slot, 1, false);
                continue block0;
            }
        }
        ItemStack result = recipe.m_8043_(this.level.m_9598_()).m_41777_();
        ItemStack remainder = this.itemHandler.insertItem(this.outputSlots[0], result, false);
        if (!remainder.m_41619_() && this.level != null && !this.level.m_5776_()) {
            System.err.println("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u0440\u0430\u0444\u0442\u0430!");
        }
    }

    @Override
    protected int getRecipeDuration(AssemblerRecipe recipe) {
        return recipe.getDuration();
    }

    @Override
    protected long getRecipeEnergyCost(AssemblerRecipe recipe) {
        return recipe != null ? (long)recipe.getPowerConsumption() : this.energyPerTick;
    }

    @Override
    @Nullable
    protected AssemblerRecipe findRecipeForItem(ItemStack stack) {
        if (this.level == null) {
            return null;
        }
        List allRecipes = this.level.m_7465_().m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
        for (AssemblerRecipe recipe : allRecipes) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(stack)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    protected boolean isRecipeValidForBlueprint(AssemblerRecipe recipe, ItemStack blueprint) {
        String recipePool = recipe.getBlueprintPool();
        if (recipePool == null || recipePool.isEmpty()) {
            return true;
        }
        if (blueprint == null || blueprint.m_41619_()) {
            return false;
        }
        CompoundTag nbt = blueprint.m_41783_();
        if (nbt == null || !nbt.m_128441_("blueprintPool")) {
            return false;
        }
        String blueprintPool = nbt.m_128461_("blueprintPool");
        return recipePool.equals(blueprintPool);
    }
}

