/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.multiblock;

import com.hbm_m.main.MainRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.phys.AABB;

public final class DoorPartAABBRegistry {
    private static final Map<String, Map<String, AABB>> REGISTRY = new ConcurrentHashMap<String, Map<String, AABB>>();

    public static synchronized void register(String doorId, Map<String, AABB> partAABBs) {
        if (partAABBs == null || partAABBs.isEmpty()) {
            MainRegistry.LOGGER.warn("DoorPartAABBRegistry: Attempted to register empty AABB map for doorId={}", (Object)doorId);
            return;
        }
        REGISTRY.put(doorId, Collections.unmodifiableMap(new HashMap<String, AABB>(partAABBs)));
        MainRegistry.LOGGER.info("DoorPartAABBRegistry: Registered {} part AABBs for doorId={}", (Object)partAABBs.size(), (Object)doorId);
    }

    public static AABB get(String doorId, String partName) {
        Map<String, AABB> parts = REGISTRY.get(doorId);
        return parts != null ? parts.get(partName) : null;
    }

    public static Map<String, AABB> getAll(String doorId) {
        Map<String, AABB> parts = REGISTRY.get(doorId);
        return parts != null ? parts : Collections.emptyMap();
    }

    public static boolean contains(String doorId) {
        return REGISTRY.containsKey(doorId);
    }

    public static void clear() {
        REGISTRY.clear();
    }

    private DoorPartAABBRegistry() {
    }
}

