/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.multiblock;

import com.hbm_m.block.DoorBlock;
import com.hbm_m.block.WireBlock;
import com.hbm_m.block.machine.UniversalMachinePartBlock;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.multiblock.DoorPartAABBRegistry;
import com.hbm_m.multiblock.IFrameSupportable;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.IMultiblockPart;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.network.HighlightBlocksPacket;
import com.hbm_m.network.ModPacketHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class MultiblockStructureHelper {
    private final Map<BlockPos, Supplier<BlockState>> structureMap;
    private final Supplier<BlockState> phantomBlockState;
    private final Set<BlockPos> partOffsets;
    private final int maxY;
    private final Set<Block> replaceableBlocks = Set.of(Blocks.f_50016_, Blocks.f_50627_, Blocks.f_50626_, Blocks.f_50125_, Blocks.f_50191_, Blocks.f_49990_, Blocks.f_49991_);

    public MultiblockStructureHelper(Map<BlockPos, Supplier<BlockState>> structureMap, Supplier<BlockState> phantomBlockState) {
        this.structureMap = Collections.unmodifiableMap(structureMap);
        this.phantomBlockState = phantomBlockState;
        this.partOffsets = Collections.unmodifiableSet(structureMap.keySet());
        this.maxY = this.computeMaxY();
    }

    private boolean isBlockReplaceable(BlockState state) {
        if (this.replaceableBlocks.contains(state.m_60734_())) {
            return true;
        }
        return state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13104_);
    }

    private int computeMaxY() {
        return this.structureMap.keySet().stream().mapToInt(Vec3i::m_123342_).max().orElse(0);
    }

    public boolean checkPlacement(Level level, BlockPos controllerPos, Direction facing, Player player) {
        ArrayList<BlockPos> obstructions = new ArrayList<BlockPos>();
        for (BlockPos relativePos : this.structureMap.keySet()) {
            BlockPos worldPos;
            BlockState existingState;
            if (relativePos.equals((Object)BlockPos.f_121853_) || this.isBlockReplaceable(existingState = level.m_8055_(worldPos = this.getRotatedPos(controllerPos, relativePos, facing)))) continue;
            obstructions.add(worldPos);
        }
        if (!obstructions.isEmpty()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (ModClothConfig.get().enableObstructionHighlight) {
                    ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new HighlightBlocksPacket(obstructions));
                }
            }
            player.m_5661_((Component)Component.m_237115_((String)"chat.hbm_m.structure.obstructed"), true);
            return false;
        }
        return true;
    }

    public Set<BlockPos> getPartOffsets() {
        return this.partOffsets;
    }

    public synchronized void placeStructure(Level level, BlockPos controllerPos, Direction facing, IMultiblockController controller) {
        if (level.f_46443_) {
            return;
        }
        ArrayList<BlockPos> energyConnectorPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> allPlacedPositions = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Supplier<BlockState>> entry : this.structureMap.entrySet()) {
            BlockPos relativePos = entry.getKey();
            if (relativePos.equals((Object)BlockPos.f_121853_)) continue;
            BlockPos worldPos = this.getRotatedPos(controllerPos, relativePos, facing);
            BlockState partState = (BlockState)this.phantomBlockState.get().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing);
            level.m_7731_(worldPos, partState, 2);
            allPlacedPositions.add(worldPos);
            BlockEntity be = level.m_7702_(worldPos);
            if (!(be instanceof IMultiblockPart)) continue;
            IMultiblockPart partBe = (IMultiblockPart)be;
            partBe.setControllerPos(controllerPos);
            PartRole role = controller.getPartRole(relativePos);
            partBe.setPartRole(role);
            if (role != PartRole.ENERGY_CONNECTOR) continue;
            energyConnectorPositions.add(worldPos);
        }
        MainRegistry.LOGGER.info("Player {} placed multiblock at {} with {} parts: {}", new Object[]{controller, controllerPos, allPlacedPositions.size(), this.formatPositions(allPlacedPositions)});
        MultiblockStructureHelper.updateFrameForController(level, controllerPos);
        for (BlockPos connectorPos : energyConnectorPositions) {
            for (Direction dir : Direction.values()) {
                BlockPos wirePos = connectorPos.m_121945_(dir);
                BlockState wireState = level.m_8055_(wirePos);
                if (!(wireState.m_60734_() instanceof WireBlock)) continue;
                level.m_46672_(wirePos, wireState.m_60734_());
            }
        }
    }

    private String formatPositions(List<BlockPos> positions) {
        if (positions.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos pos = positions.get(i);
            sb.append(String.format("(%d,%d,%d)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            if (i >= positions.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void destroyStructure(Level level, BlockPos controllerPos, Direction facing) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_8055_(controllerPos).m_60734_() instanceof IMultiblockController) {
            level.m_7731_(controllerPos, Blocks.f_50016_.m_49966_(), 3);
        }
        for (BlockPos relativePos : this.structureMap.keySet()) {
            BlockPos worldPos;
            BlockState stateInWorld;
            if (relativePos.equals((Object)BlockPos.f_121853_) || !((stateInWorld = level.m_8055_(worldPos = this.getRotatedPos(controllerPos, relativePos, facing))).m_60734_() instanceof UniversalMachinePartBlock)) continue;
            level.m_7731_(worldPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private int getMaxY() {
        int maxY = Integer.MIN_VALUE;
        for (BlockPos local : this.structureMap.keySet()) {
            if (local.m_123342_() <= maxY) continue;
            maxY = local.m_123342_();
        }
        return maxY;
    }

    public Map<BlockPos, Supplier<BlockState>> getStructureMap() {
        return this.structureMap;
    }

    public boolean isTopRingPart(BlockPos localOffset) {
        int maxY = this.getMaxY();
        return localOffset.m_123342_() == maxY;
    }

    public List<BlockPos> getTopRingWorldPositions(BlockPos controllerPos, Direction facing) {
        ArrayList<BlockPos> topRing = new ArrayList<BlockPos>();
        int maxY = this.getMaxY();
        for (BlockPos localOffset : this.structureMap.keySet()) {
            if (localOffset.m_123342_() != maxY) continue;
            BlockPos worldPos = this.getRotatedPos(controllerPos, localOffset, facing);
            topRing.add(worldPos);
        }
        return topRing;
    }

    public boolean computeFrameVisible(Level level, BlockPos controllerPos, Direction facing) {
        List<BlockPos> topRingWorld = this.getTopRingWorldPositions(controllerPos, facing);
        for (BlockPos p : topRingWorld) {
            BlockPos above = p.m_7494_();
            if (level.m_46859_(above)) continue;
            return true;
        }
        return false;
    }

    public static void updateFrameForController(Level level, BlockPos controllerPos) {
        if (level.m_5776_()) {
            return;
        }
        BlockState state = level.m_8055_(controllerPos);
        Block block = state.m_60734_();
        if (!(block instanceof IMultiblockController)) {
            return;
        }
        IMultiblockController controller = (IMultiblockController)block;
        BlockEntity be = level.m_7702_(controllerPos);
        if (!(be instanceof IFrameSupportable)) {
            return;
        }
        IFrameSupportable frameSupportable = (IFrameSupportable)be;
        if (!state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        MultiblockStructureHelper helper = controller.getStructureHelper();
        if (helper == null) {
            return;
        }
        boolean visible = helper.computeFrameVisible(level, controllerPos, facing);
        frameSupportable.setFrameVisible(visible);
    }

    public static void onNeighborChangedForPart(Level level, BlockPos partPos, BlockPos changedPos) {
        if (level.m_5776_() || level.m_7654_() == null) {
            return;
        }
        BlockEntity partBe = level.m_7702_(partPos);
        if (!(partBe instanceof IMultiblockPart)) {
            return;
        }
        IMultiblockPart part = (IMultiblockPart)partBe;
        BlockPos ctrlPos = part.getControllerPos();
        if (ctrlPos == null) {
            return;
        }
        BlockState controllerState = level.m_8055_(ctrlPos);
        Block controllerBlock = controllerState.m_60734_();
        if (!(controllerBlock instanceof IMultiblockController)) {
            return;
        }
        IMultiblockController controller = (IMultiblockController)controllerBlock;
        MultiblockStructureHelper helper = controller.getStructureHelper();
        BlockPos worldOffset = partPos.m_121996_((Vec3i)ctrlPos);
        Direction facing = (Direction)controllerState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos localOffset = MultiblockStructureHelper.rotateBack(worldOffset, facing);
        if (helper.isTopRingPart(localOffset) && changedPos.equals((Object)partPos.m_7494_())) {
            level.m_7654_().execute(() -> {
                BlockEntity be = level.m_7702_(ctrlPos);
                if (be != null && !be.m_58901_() && level.m_8055_(ctrlPos).m_60713_(controllerBlock)) {
                    MultiblockStructureHelper.updateFrameForController(level, ctrlPos);
                }
            });
        }
    }

    private static BlockPos rotateBack(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            case Direction.WEST -> new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            case Direction.EAST -> new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            default -> pos;
        };
    }

    public VoxelShape generateShapeFromParts(Direction facing) {
        VoxelShape finalShape = Shapes.m_83040_();
        finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        for (BlockPos localOffset : this.structureMap.keySet()) {
            if (localOffset.equals((Object)BlockPos.f_121853_)) continue;
            BlockPos rotatedOffset = MultiblockStructureHelper.rotate(localOffset, facing);
            VoxelShape partShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0).m_83216_((double)rotatedOffset.m_123341_(), (double)rotatedOffset.m_123342_(), (double)rotatedOffset.m_123343_());
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)partShape);
        }
        return finalShape.m_83296_();
    }

    public static Map<String, AABB> getDoorPartAABBs(String doorId) {
        return DoorPartAABBRegistry.getAll(doorId);
    }

    public static VoxelShape generateShapeFromDoorParts(String doorId, List<String> visibleParts, Direction facing) {
        Map<String, AABB> allAABBs = MultiblockStructureHelper.getDoorPartAABBs(doorId);
        if (allAABBs.isEmpty()) {
            return Shapes.m_83040_();
        }
        int[] dims = DoorBlock.getDoorDimensions(doorId);
        double widthBlocks = (double)dims[3] + 1.0;
        double heightBlocks = (double)dims[4] + 1.0;
        double depthBlocks = (double)dims[5] + 1.0;
        double offsetX = dims[0];
        double offsetY = dims[1];
        double offsetZ = dims[2];
        VoxelShape finalShape = Shapes.m_83040_();
        for (String partName : visibleParts) {
            AABB raw = allAABBs.get(partName);
            if (raw == null) continue;
            boolean needsRotation = MultiblockStructureHelper.needsModelRotation(doorId);
            AABB scaled = needsRotation ? new AABB(raw.f_82289_ * widthBlocks + offsetX, raw.f_82288_ * heightBlocks + offsetY, raw.f_82290_ * depthBlocks + offsetZ, raw.f_82292_ * widthBlocks + offsetX, raw.f_82291_ * heightBlocks + offsetY, raw.f_82293_ * depthBlocks + offsetZ) : new AABB(raw.f_82288_ * widthBlocks + offsetX, raw.f_82289_ * heightBlocks + offsetY, raw.f_82290_ * depthBlocks + offsetZ, raw.f_82291_ * widthBlocks + offsetX, raw.f_82292_ * heightBlocks + offsetY, raw.f_82293_ * depthBlocks + offsetZ);
            AABB rotated = MultiblockStructureHelper.rotateAABBByFacing(scaled, facing);
            VoxelShape partShape = Block.m_49796_((double)(rotated.f_82288_ * 16.0), (double)(rotated.f_82289_ * 16.0), (double)(rotated.f_82290_ * 16.0), (double)(rotated.f_82291_ * 16.0), (double)(rotated.f_82292_ * 16.0), (double)(rotated.f_82293_ * 16.0));
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)partShape);
        }
        return finalShape.m_83296_();
    }

    private static boolean needsModelRotation(String doorId) {
        return switch (doorId) {
            case "large_vehicle_door", "sliding_blast_door", "secure_access_door", "transition_seal", "round_airlock_door", "fire_door" -> true;
            default -> false;
        };
    }

    public static AABB rotateAABBByFacing(AABB aabb, Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> new AABB(-aabb.f_82291_, aabb.f_82289_, -aabb.f_82293_, -aabb.f_82288_, aabb.f_82292_, -aabb.f_82290_);
            case Direction.WEST -> new AABB(-aabb.f_82293_, aabb.f_82289_, aabb.f_82288_, -aabb.f_82290_, aabb.f_82292_, aabb.f_82291_);
            case Direction.EAST -> new AABB(aabb.f_82290_, aabb.f_82289_, -aabb.f_82291_, aabb.f_82293_, aabb.f_82292_, -aabb.f_82288_);
            default -> aabb;
        };
    }

    public BlockPos getRotatedPos(BlockPos controllerPos, BlockPos localOffset, Direction facing) {
        return controllerPos.m_121955_((Vec3i)MultiblockStructureHelper.rotate(localOffset, facing));
    }

    public static BlockPos rotate(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            case Direction.WEST -> new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            case Direction.EAST -> new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            default -> pos;
        };
    }

    public List<BlockPos> getAllPartPositions(BlockPos controllerPos, Direction facing) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (BlockPos localOffset : this.structureMap.keySet()) {
            BlockPos worldPos = this.getRotatedPos(controllerPos, localOffset, facing);
            positions.add(worldPos);
        }
        return positions;
    }
}

