/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.menu.AnvilMenu;
import com.hbm_m.recipe.AnvilRecipe;
import com.hbm_m.recipe.AnvilRecipeManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class AnvilSelectRecipeC2SPacket {
    private final BlockPos pos;
    @Nullable
    private final ResourceLocation recipeId;

    public AnvilSelectRecipeC2SPacket(BlockPos pos, @Nullable ResourceLocation recipeId) {
        this.pos = pos;
        this.recipeId = recipeId;
    }

    public static void encode(AnvilSelectRecipeC2SPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        if (packet.recipeId != null) {
            buffer.writeBoolean(true);
            buffer.m_130085_(packet.recipeId);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static AnvilSelectRecipeC2SPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ResourceLocation recipeId = buffer.readBoolean() ? buffer.m_130281_() : null;
        return new AnvilSelectRecipeC2SPacket(pos, recipeId);
    }

    public static void handle(AnvilSelectRecipeC2SPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1717$temp = player.f_36096_;
            if (patt1717$temp instanceof AnvilMenu) {
                AnvilMenu menu = (AnvilMenu)patt1717$temp;
                if (menu.blockEntity.m_58899_().equals((Object)packet.pos)) {
                    menu.blockEntity.setSelectedRecipeId(packet.recipeId);
                    if (packet.recipeId != null) {
                        AnvilRecipeManager.getRecipe(player.m_9236_(), packet.recipeId).ifPresent(recipe -> menu.blockEntity.populateInputsFromPlayer(player, (AnvilRecipe)recipe));
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

