/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.client.ClientRadiationData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ChunkRadiationDebugBatchPacket {
    private final Map<ChunkPos, Float> radiationData;
    private final ResourceLocation dimension;

    public ChunkRadiationDebugBatchPacket(Map<ChunkPos, Float> radiationData, ResourceLocation dimension) {
        this.radiationData = radiationData;
        this.dimension = dimension;
    }

    public static void encode(ChunkRadiationDebugBatchPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.dimension);
        buf.m_130130_(msg.radiationData.size());
        for (Map.Entry<ChunkPos, Float> entry : msg.radiationData.entrySet()) {
            buf.m_178341_(entry.getKey());
            buf.writeFloat(entry.getValue().floatValue());
        }
    }

    public static ChunkRadiationDebugBatchPacket decode(FriendlyByteBuf buf) {
        ResourceLocation dimension = buf.m_130281_();
        int size = buf.m_130242_();
        HashMap<ChunkPos, Float> data = new HashMap<ChunkPos, Float>(size);
        for (int i = 0; i < size; ++i) {
            data.put(buf.m_178383_(), Float.valueOf(buf.readFloat()));
        }
        return new ChunkRadiationDebugBatchPacket(data, dimension);
    }

    public static void handle(ChunkRadiationDebugBatchPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handlePacket(msg)));
        ctx.get().setPacketHandled(true);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handlePacket(ChunkRadiationDebugBatchPacket msg) {
            ClientRadiationData.updateRadiationData(msg.dimension, msg.radiationData);
        }
    }
}

