/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.item.tools.MultiDetonatorItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClearPointPacket {
    private int pointIndex;

    public ClearPointPacket(int pointIndex) {
        this.pointIndex = pointIndex;
    }

    public ClearPointPacket() {
        this.pointIndex = 0;
    }

    public static void encode(ClearPointPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pointIndex);
    }

    public static ClearPointPacket decode(FriendlyByteBuf buf) {
        return new ClearPointPacket(buf.readInt());
    }

    public static boolean handle(ClearPointPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ClearPointPacket.handleClearPoint(player, msg.pointIndex);
            }
        });
        return true;
    }

    private static void handleClearPoint(ServerPlayer player, int pointIndex) {
        ItemStack mainItem = player.m_21205_();
        ItemStack offItem = player.m_21206_();
        ItemStack detonatorStack = ItemStack.f_41583_;
        if (mainItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = mainItem;
        } else if (offItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = offItem;
        }
        if (!detonatorStack.m_41619_()) {
            MultiDetonatorItem detonatorItem = (MultiDetonatorItem)detonatorStack.m_41720_();
            detonatorItem.clearPoint(detonatorStack, pointIndex);
            player.f_36096_.m_38946_();
        }
    }
}

