/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.item.tools.MultiDetonatorItem;
import com.hbm_m.sound.ModSounds;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class DetonateAllPacket {
    private CompoundTag tag;

    public DetonateAllPacket(CompoundTag tag) {
        this.tag = tag;
    }

    public DetonateAllPacket() {
        this.tag = new CompoundTag();
    }

    public static void encode(DetonateAllPacket msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tag);
    }

    public static DetonateAllPacket decode(FriendlyByteBuf buf) {
        return new DetonateAllPacket(buf.m_130260_());
    }

    public static boolean handle(DetonateAllPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                DetonateAllPacket.handleDetonation(player);
            }
        });
        return true;
    }

    private static void handleDetonation(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        if (level == null) {
            return;
        }
        ItemStack mainItem = player.m_21205_();
        ItemStack offItem = player.m_21206_();
        ItemStack detonatorStack = ItemStack.f_41583_;
        if (mainItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = mainItem;
        } else if (offItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = offItem;
        }
        if (detonatorStack.m_41619_()) {
            player.m_5661_((Component)Component.m_237113_((String)"Multi-Detonator \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!").m_130940_(ChatFormatting.RED), false);
            return;
        }
        MultiDetonatorItem detonatorItem = (MultiDetonatorItem)detonatorStack.m_41720_();
        int successCount = 0;
        int POINTS_COUNT = detonatorItem.getMaxPoints();
        for (int i = 0; i < POINTS_COUNT; ++i) {
            MultiDetonatorItem.PointData pointData = detonatorItem.getPointData(detonatorStack, i);
            if (pointData == null || !pointData.hasTarget) continue;
            BlockPos targetPos = new BlockPos(pointData.x, pointData.y, pointData.z);
            if (!level.m_46749_(targetPos)) {
                player.m_5661_((Component)Component.m_237113_((String)(pointData.name + " \u274c \u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430")).m_130940_(ChatFormatting.RED), false);
                continue;
            }
            BlockState state = level.m_8055_(targetPos);
            Block block = state.m_60734_();
            if (block instanceof IDetonatable) {
                IDetonatable detonatable = (IDetonatable)block;
                try {
                    boolean success = detonatable.onDetonate((Level)level, targetPos, state, (Player)player);
                    if (success) {
                        player.m_5661_((Component)Component.m_237113_((String)(pointData.name + " \u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e")).m_130940_(ChatFormatting.GREEN), false);
                        if (ModSounds.TOOL_TECH_BLEEP.isPresent()) {
                            SoundEvent soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BLEEP.get();
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
                        }
                        ++successCount;
                        continue;
                    }
                    player.m_5661_((Component)Component.m_237113_((String)(pointData.name + " \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c")).m_130940_(ChatFormatting.RED), false);
                }
                catch (Exception e) {
                    player.m_5661_((Component)Component.m_237113_((String)(pointData.name + " \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438")).m_130940_(ChatFormatting.RED), false);
                    e.printStackTrace();
                }
                continue;
            }
            player.m_5661_((Component)Component.m_237113_((String)(pointData.name + " \u0411\u043b\u043e\u043a \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c")).m_130940_(ChatFormatting.RED), false);
        }
        player.m_5661_((Component)Component.m_237113_((String)("\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e: " + successCount + "/" + POINTS_COUNT)).m_130940_(successCount == POINTS_COUNT ? ChatFormatting.GREEN : ChatFormatting.YELLOW), false);
    }
}

