/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.item.ModItems;
import com.hbm_m.util.TemplateCraftingCosts;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class GiveTemplateC2SPacket {
    private final ItemStack recipeOutput;

    public GiveTemplateC2SPacket(ItemStack recipeOutput) {
        this.recipeOutput = recipeOutput;
    }

    public GiveTemplateC2SPacket(FriendlyByteBuf buf) {
        this.recipeOutput = buf.m_130267_();
    }

    public static void encode(GiveTemplateC2SPacket packet, FriendlyByteBuf buf) {
        buf.m_130055_(packet.recipeOutput);
    }

    public static GiveTemplateC2SPacket decode(FriendlyByteBuf buf) {
        return new GiveTemplateC2SPacket(buf);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (player.m_7500_()) {
                this.handleCreativeMode(player);
            } else {
                this.handleSurvivalMode(player);
            }
        });
        return true;
    }

    private void handleCreativeMode(ServerPlayer player) {
        if (this.isStamp(this.recipeOutput)) {
            player.m_150109_().m_36054_(this.recipeOutput.m_41777_());
        } else {
            ItemStack newTemplate = new ItemStack((ItemLike)ModItems.ASSEMBLY_TEMPLATE.get());
            ItemAssemblyTemplate.writeRecipeOutput(newTemplate, this.recipeOutput);
            player.m_150109_().m_36054_(newTemplate);
        }
    }

    private void handleSurvivalMode(ServerPlayer player) {
        if (this.isStamp(this.recipeOutput)) {
            this.handleStampCrafting(player);
        } else {
            this.handleTemplateCrafting(player);
        }
    }

    private void handleStampCrafting(ServerPlayer player) {
        NonNullList<Ingredient> cost = TemplateCraftingCosts.getCostForStamp(this.recipeOutput);
        if (cost == null) {
            return;
        }
        ArrayList<ItemStack> simulatedInventory = new ArrayList<ItemStack>();
        for (Object stack : player.m_150109_().f_35974_) {
            simulatedInventory.add(stack.m_41777_());
        }
        boolean canCraft = true;
        block1: for (Ingredient ingredient : cost) {
            for (ItemStack stackInSlot : simulatedInventory) {
                if (!ingredient.test(stackInSlot)) continue;
                stackInSlot.m_41774_(1);
                continue block1;
            }
            canCraft = false;
            break;
        }
        if (canCraft) {
            block3: for (Ingredient ingredient : cost) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stackInSlot;
                    stackInSlot = player.m_150109_().m_8020_(i);
                    if (!ingredient.test(stackInSlot)) continue;
                    stackInSlot.m_41774_(1);
                    continue block3;
                }
            }
            ItemStack resultStamp = this.recipeOutput.m_41777_();
            resultStamp.m_41764_(1);
            player.m_150109_().m_36054_(resultStamp);
        }
    }

    private void handleTemplateCrafting(ServerPlayer player) {
        NonNullList<Ingredient> cost = TemplateCraftingCosts.getCostForTemplate(this.recipeOutput);
        if (cost == null) {
            return;
        }
        ArrayList<ItemStack> simulatedInventory = new ArrayList<ItemStack>();
        for (Object stack : player.m_150109_().f_35974_) {
            simulatedInventory.add(stack.m_41777_());
        }
        boolean canCraft = true;
        block1: for (Ingredient ingredient : cost) {
            for (ItemStack stackInSlot : simulatedInventory) {
                if (!ingredient.test(stackInSlot)) continue;
                stackInSlot.m_41774_(1);
                continue block1;
            }
            canCraft = false;
            break;
        }
        if (canCraft) {
            block3: for (Ingredient ingredient : cost) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stackInSlot;
                    stackInSlot = player.m_150109_().m_8020_(i);
                    if (!ingredient.test(stackInSlot)) continue;
                    stackInSlot.m_41774_(1);
                    continue block3;
                }
            }
            ItemStack newTemplate = new ItemStack((ItemLike)ModItems.ASSEMBLY_TEMPLATE.get());
            ItemAssemblyTemplate.writeRecipeOutput(newTemplate, this.recipeOutput);
            player.m_150109_().m_36054_(newTemplate);
        }
    }

    private boolean isStamp(ItemStack stack) {
        return TemplateCraftingCosts.isStamp(stack);
    }
}

