/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.item.tools.MultiDetonatorItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetActivePointPacket {
    private int pointIndex;

    public SetActivePointPacket(int pointIndex) {
        this.pointIndex = pointIndex;
    }

    public SetActivePointPacket() {
        this.pointIndex = 0;
    }

    public static void encode(SetActivePointPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pointIndex);
    }

    public static SetActivePointPacket decode(FriendlyByteBuf buf) {
        return new SetActivePointPacket(buf.readInt());
    }

    public static boolean handle(SetActivePointPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                SetActivePointPacket.handleSetActivePoint(player, msg.pointIndex);
            }
        });
        return true;
    }

    private static void handleSetActivePoint(ServerPlayer player, int pointIndex) {
        ItemStack mainItem = player.m_21205_();
        ItemStack offItem = player.m_21206_();
        ItemStack detonatorStack = ItemStack.f_41583_;
        if (mainItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = mainItem;
        } else if (offItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = offItem;
        }
        if (!detonatorStack.m_41619_()) {
            MultiDetonatorItem detonatorItem = (MultiDetonatorItem)detonatorStack.m_41720_();
            detonatorItem.setActivePoint(detonatorStack, pointIndex);
        }
    }
}

