/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.block.entity.machine.MachineAdvancedAssemblerBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetAssemblerRecipeC2SPacket {
    private final BlockPos blockPos;
    @Nullable
    private final ResourceLocation recipeId;

    public SetAssemblerRecipeC2SPacket(BlockPos blockPos, @Nullable ResourceLocation recipeId) {
        this.blockPos = blockPos;
        this.recipeId = recipeId;
    }

    public SetAssemblerRecipeC2SPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        boolean hasRecipe = buf.readBoolean();
        this.recipeId = hasRecipe ? buf.m_130281_() : null;
    }

    public static void encode(SetAssemblerRecipeC2SPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.writeBoolean(packet.recipeId != null);
        if (packet.recipeId != null) {
            buf.m_130085_(packet.recipeId);
        }
    }

    public static SetAssemblerRecipeC2SPacket decode(FriendlyByteBuf buf) {
        return new SetAssemblerRecipeC2SPacket(buf);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (player.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5) > 64.0) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(this.blockPos);
            if (blockEntity instanceof MachineAdvancedAssemblerBlockEntity) {
                MachineAdvancedAssemblerBlockEntity assembler = (MachineAdvancedAssemblerBlockEntity)blockEntity;
                assembler.setSelectedRecipe(this.recipeId);
            }
        });
        return true;
    }
}

