/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnAlwaysVisibleParticlePacket {
    private final ResourceLocation particleTypeId;
    private final double x;
    private final double y;
    private final double z;
    private final double xSpeed;
    private final double ySpeed;
    private final double zSpeed;

    public SpawnAlwaysVisibleParticlePacket(ParticleType<?> particleType, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.particleTypeId = ForgeRegistries.PARTICLE_TYPES.getKey(particleType);
        this.x = x;
        this.y = y;
        this.z = z;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
    }

    public SpawnAlwaysVisibleParticlePacket(FriendlyByteBuf buf) {
        this.particleTypeId = buf.m_130281_();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xSpeed = buf.readDouble();
        this.ySpeed = buf.readDouble();
        this.zSpeed = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.particleTypeId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xSpeed);
        buf.writeDouble(this.ySpeed);
        buf.writeDouble(this.zSpeed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(this.particleTypeId);
            if (particleType != null && Minecraft.m_91087_().f_91073_ != null) {
                Minecraft.m_91087_().f_91073_.m_7107_((ParticleOptions)particleType, this.x, this.y, this.z, this.xSpeed, this.ySpeed, this.zSpeed);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

