/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.item.tools.MultiDetonatorItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SyncPointPacket {
    private int pointIndex;
    private String pointName;
    private int x;
    private int y;
    private int z;
    private boolean hasTarget;

    public SyncPointPacket(int pointIndex, String pointName, int x, int y, int z, boolean hasTarget) {
        this.pointIndex = pointIndex;
        this.pointName = pointName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.hasTarget = hasTarget;
    }

    public SyncPointPacket() {
        this.pointIndex = 0;
        this.pointName = "";
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.hasTarget = false;
    }

    public static void encode(SyncPointPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pointIndex);
        buf.m_130070_(msg.pointName);
        buf.writeInt(msg.x);
        buf.writeInt(msg.y);
        buf.writeInt(msg.z);
        buf.writeBoolean(msg.hasTarget);
    }

    public static SyncPointPacket decode(FriendlyByteBuf buf) {
        return new SyncPointPacket(buf.readInt(), buf.m_130136_(16), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    public static boolean handle(SyncPointPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                SyncPointPacket.handleSyncPoint(player, msg);
            }
        });
        return true;
    }

    private static void handleSyncPoint(ServerPlayer player, SyncPointPacket msg) {
        ItemStack mainItem = player.m_21205_();
        ItemStack offItem = player.m_21206_();
        ItemStack detonatorStack = ItemStack.f_41583_;
        if (mainItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = mainItem;
        } else if (offItem.m_41720_() instanceof MultiDetonatorItem) {
            detonatorStack = offItem;
        }
        if (!detonatorStack.m_41619_()) {
            CompoundTag nbt;
            MultiDetonatorItem detonatorItem = (MultiDetonatorItem)detonatorStack.m_41720_();
            if (!detonatorStack.m_41782_()) {
                detonatorStack.m_41751_(new CompoundTag());
            }
            if (!(nbt = detonatorStack.m_41783_()).m_128425_("Points", 9)) {
                nbt.m_128365_("Points", (Tag)new ListTag());
            }
            ListTag pointsList = nbt.m_128437_("Points", 10);
            while (pointsList.size() <= msg.pointIndex) {
                CompoundTag emptyTag = new CompoundTag();
                emptyTag.m_128405_("X", 0);
                emptyTag.m_128405_("Y", 0);
                emptyTag.m_128405_("Z", 0);
                emptyTag.m_128359_("Name", "");
                emptyTag.m_128379_("HasTarget", false);
                pointsList.add((Object)emptyTag);
            }
            CompoundTag pointTag = pointsList.m_128728_(msg.pointIndex);
            pointTag.m_128405_("X", msg.x);
            pointTag.m_128405_("Y", msg.y);
            pointTag.m_128405_("Z", msg.z);
            pointTag.m_128359_("Name", msg.pointName);
            pointTag.m_128379_("HasTarget", msg.hasTarget);
            pointsList.set(msg.pointIndex, (Tag)pointTag);
            nbt.m_128365_("Points", (Tag)pointsList);
        }
    }
}

