/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.physics;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public final class PartAABBExtractor {
    private static final RandomSource RANDOM = RandomSource.m_216335_((long)0L);

    public static AABB extract(BakedModel partModel) {
        if (partModel == null) {
            return null;
        }
        ArrayList allQuads = new ArrayList();
        allQuads.addAll(partModel.getQuads(null, null, RANDOM, ModelData.EMPTY, null));
        for (Direction dir : Direction.values()) {
            allQuads.addAll(partModel.getQuads(null, dir, RANDOM, ModelData.EMPTY, null));
        }
        if (allQuads.isEmpty()) {
            return null;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (BakedQuad quad : allQuads) {
            int[] vertexData = quad.m_111303_();
            int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
            for (int v = 0; v < 4; ++v) {
                int offset = v * vertexSize;
                float x = Float.intBitsToFloat(vertexData[offset + 0]);
                float y = Float.intBitsToFloat(vertexData[offset + 1]);
                float z = Float.intBitsToFloat(vertexData[offset + 2]);
                double bx = (double)x / 16.0;
                double by = (double)y / 16.0;
                double bz = (double)z / 16.0;
                minX = Math.min(minX, bx);
                minY = Math.min(minY, by);
                minZ = Math.min(minZ, bz);
                maxX = Math.max(maxX, bx);
                maxY = Math.max(maxY, by);
                maxZ = Math.max(maxZ, bz);
            }
        }
        if (Double.isInfinite(minX)) {
            return null;
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Map<String, AABB> extractAll(Map<String, BakedModel> parts) {
        HashMap<String, AABB> result = new HashMap<String, AABB>();
        for (Map.Entry<String, BakedModel> entry : parts.entrySet()) {
            AABB aabb = PartAABBExtractor.extract(entry.getValue());
            if (aabb == null) continue;
            result.put(entry.getKey(), aabb);
        }
        return result;
    }

    private PartAABBExtractor() {
    }
}

