/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.radiation;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.RadioactiveBlock;
import com.hbm_m.capability.ChunkRadiationProvider;
import com.hbm_m.capability.IChunkRadiation;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.hazard.HazardSystem;
import com.hbm_m.hazard.HazardType;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.network.ChunkRadiationDebugBatchPacket;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.particle.ModParticleTypes;
import com.hbm_m.radiation.ChunkRadiationHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChunkRadiationHandlerSimple
extends ChunkRadiationHandler {
    private static final float MAX_RAD = ModClothConfig.get().maxRad;
    private final Map<ResourceLocation, Set<ChunkPos>> activeChunksByDimension = new ConcurrentHashMap<ResourceLocation, Set<ChunkPos>>();
    private final Map<UUID, Map<ChunkPos, Float>> lastSentDebugValues = new ConcurrentHashMap<UUID, Map<ChunkPos, Float>>();

    public static Optional<IChunkRadiation> getChunkRadiationCap(LevelChunk chunk) {
        return chunk.getCapability(ChunkRadiationProvider.CHUNK_RADIATION_CAPABILITY).resolve();
    }

    @Override
    public void onBlockUpdated(Level level, BlockPos pos) {
    }

    @Override
    public void updateSystem() {
        if (!ModClothConfig.get().enableRadiation || !ModClothConfig.get().enableChunkRads) {
            return;
        }
        for (Map.Entry<ResourceLocation, Set<ChunkPos>> dimensionEntry : this.activeChunksByDimension.entrySet()) {
            Set<ChunkPos> currentActiveChunks;
            ResourceLocation dimId = dimensionEntry.getKey();
            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId);
            ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(levelKey);
            if (level == null || level.m_5776_() || (currentActiveChunks = dimensionEntry.getValue()) == null || currentActiveChunks.isEmpty()) continue;
            HashMap ambientReadBuffer = new HashMap();
            HashMap blockReadBuffer = new HashMap();
            for (ChunkPos chunkPos : new HashSet<ChunkPos>(currentActiveChunks)) {
                LevelChunk chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                if (chunk == null) continue;
                ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> {
                    ambientReadBuffer.put(chunkPos, Float.valueOf(cap.getAmbientRadiation()));
                    blockReadBuffer.put(chunkPos, Float.valueOf(cap.getBlockRadiation()));
                });
            }
            HashMap<ChunkPos, Float> writeBuffer = new HashMap<ChunkPos, Float>();
            for (Map.Entry entry : ambientReadBuffer.entrySet()) {
                ChunkPos pos3 = (ChunkPos)entry.getKey();
                float ambientToSpread = ((Float)entry.getValue()).floatValue();
                if (!(ambientToSpread > 1.0E-6f)) continue;
                float spreadFactor = 0.95f;
                float totalToSpread = ambientToSpread * spreadFactor;
                float centerShare = totalToSpread * 0.6f;
                float cardinalShare = totalToSpread * 0.075f;
                float diagonalShare = totalToSpread * 0.025f;
                if (centerShare > 0.0f) {
                    writeBuffer.merge(pos3, Float.valueOf(centerShare), Float::sum);
                }
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        float share;
                        if (dx == 0 && dz == 0) continue;
                        float f = share = Math.abs(dx) + Math.abs(dz) == 1 ? cardinalShare : diagonalShare;
                        if (!(share > 0.1f)) continue;
                        ChunkPos neighbor = new ChunkPos(pos3.f_45578_ + dx, pos3.f_45579_ + dz);
                        writeBuffer.merge(neighbor, Float.valueOf(share), Float::sum);
                    }
                }
            }
            HashSet<ChunkPos> hashSet = new HashSet<ChunkPos>(currentActiveChunks);
            hashSet.addAll(writeBuffer.keySet());
            ConcurrentHashMap.KeySetView nextActiveChunks = ConcurrentHashMap.newKeySet();
            for (ChunkPos pos4 : hashSet) {
                float clearThreshold;
                LevelChunk chunk = level.m_7726_().m_62227_(pos4.f_45578_, pos4.f_45579_, false);
                if (chunk == null) continue;
                float oldAmbient = ambientReadBuffer.getOrDefault(pos4, Float.valueOf(0.0f)).floatValue();
                float newAmbient = writeBuffer.getOrDefault(pos4, Float.valueOf(0.0f)).floatValue();
                float generation = blockReadBuffer.getOrDefault(pos4, Float.valueOf(0.0f)).floatValue();
                if (generation > 1.0E-6f) {
                    newAmbient += generation * ModClothConfig.get().radSourceInfluenceFactor;
                }
                float decayPercent = 0.05f;
                float decayFlat = 0.1f;
                newAmbient -= newAmbient * decayPercent + decayFlat;
                float fluctuationFactor = ModClothConfig.get().radRandomizationFactor;
                if (fluctuationFactor > 0.0f && newAmbient > 0.1f) {
                    newAmbient *= 1.0f + (level.f_46441_.m_188501_() - 0.5f) * fluctuationFactor;
                }
                if (newAmbient < (clearThreshold = 0.01f)) {
                    newAmbient = 0.0f;
                }
                float finalAmbientRad = newAmbient = Mth.m_14036_((float)newAmbient, (float)0.0f, (float)MAX_RAD);
                if (ModClothConfig.get().enableRadFogEffect && finalAmbientRad > ModClothConfig.get().radFogThreshold && level.f_46441_.m_188503_(ModClothConfig.get().radFogChance) == 0) {
                    int x = pos4.m_45604_() + level.f_46441_.m_188503_(16);
                    int z = pos4.m_45605_() + level.f_46441_.m_188503_(16);
                    int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
                    level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.RAD_FOG_PARTICLE.get()), (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 7, 1.5, 0.5, 1.5, 0.01);
                }
                ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> {
                    if (Math.abs(cap.getAmbientRadiation() - finalAmbientRad) > 1.0E-6f) {
                        cap.setAmbientRadiation(finalAmbientRad);
                        chunk.m_8092_(true);
                        if (ModClothConfig.get().enableDebugLogging) {
                            MainRegistry.LOGGER.debug("[RadSim] Tick update for chunk [{}, {}]: OldAmb: {}, SpreadIn: {}, Gen: {}, NewAmb: {}", new Object[]{pos.f_45578_, pos.f_45579_, Float.valueOf(oldAmbient), writeBuffer.getOrDefault(pos4, Float.valueOf(0.0f)), Float.valueOf(generation), Float.valueOf(finalAmbientRad)});
                        }
                    }
                    if (finalAmbientRad > 1.0E-6f || cap.getBlockRadiation() > 1.0E-6f) {
                        nextActiveChunks.add(pos4);
                    } else if (currentActiveChunks.contains(pos4) && ModClothConfig.get().enableDebugLogging) {
                        MainRegistry.LOGGER.debug("[RadSim] Chunk {} REMOVED from active list (all radiation gone)", (Object)pos4);
                    }
                });
                if (!ModClothConfig.get().worldRadEffects || !(finalAmbientRad > ModClothConfig.get().worldRadEffectsThreshold)) continue;
                this.handleWorldDestruction(level, pos4, finalAmbientRad);
            }
            this.activeChunksByDimension.put(dimId, nextActiveChunks);
            this.sendDebugPackets(level);
        }
    }

    @Override
    public void recalculateChunkRadiation(LevelChunk chunk) {
        float totalBlockRadiation = 0.0f;
        for (LevelChunkSection section : chunk.m_7103_()) {
            if (section == null || section.m_188008_()) continue;
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        float blockRad;
                        BlockState blockState = section.m_62982_(x, y, z);
                        if (blockState.m_60795_() || !((blockRad = HazardSystem.getHazardLevelFromState(blockState, HazardType.RADIATION)) > 0.0f)) continue;
                        totalBlockRadiation += blockRad;
                    }
                }
            }
        }
        float finalTotalBlockRadiation = totalBlockRadiation;
        ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> {
            if (Math.abs(cap.getBlockRadiation() - finalTotalBlockRadiation) > 1.0E-6f) {
                cap.setBlockRadiation(finalTotalBlockRadiation);
                chunk.m_8092_(true);
            }
            if (cap.getAmbientRadiation() > 1.0E-6f || finalTotalBlockRadiation > 1.0E-6f) {
                this.activeChunksByDimension.computeIfAbsent(chunk.m_62953_().m_46472_().m_135782_(), k -> ConcurrentHashMap.newKeySet()).add(chunk.m_7697_());
            }
        });
    }

    @Override
    public void receiveChunkLoad(LevelChunk chunk) {
        this.recalculateChunkRadiation(chunk);
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        LevelChunk chunk;
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk && !(chunk = (LevelChunk)chunkAccess).m_62953_().m_5776_()) {
            Optional.ofNullable(this.activeChunksByDimension.get(chunk.m_62953_().m_46472_().m_135782_())).ifPresent(set -> set.remove(chunk.m_7697_()));
        }
    }

    @Override
    public float getRadiation(Level level, int x, int y, int z) {
        if (level == null || level.m_5776_()) {
            return 0.0f;
        }
        LevelChunk chunkAccess = level.m_6325_(x >> 4, z >> 4);
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = chunkAccess;
            AtomicReference<Float> radiation = new AtomicReference<Float>(Float.valueOf(0.0f));
            ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> radiation.set(Float.valueOf(cap.getAmbientRadiation())));
            return radiation.get().floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(Level level, int x, int y, int z, float rad) {
        if (level == null || level.m_5776_()) {
            return;
        }
        LevelChunk chunkAccess = level.m_6325_(x >> 4, z >> 4);
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = chunkAccess;
            ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> {
                cap.setAmbientRadiation(rad);
                chunk.m_8092_(true);
                if (rad > 1.0E-6f) {
                    this.activeChunksByDimension.computeIfAbsent(level.m_46472_().m_135782_(), k -> ConcurrentHashMap.newKeySet()).add(chunk.m_7697_());
                }
            });
        }
    }

    @Override
    public void incrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, this.getRadiation(level, x, y, z) + rad);
    }

    @Override
    public void decrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, Math.max(0.0f, this.getRadiation(level, x, y, z) - rad));
    }

    @Override
    public void incrementBlockRadiation(Level level, BlockPos pos, float diff) {
        if (level.m_5776_()) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        if (chunk == null) {
            return;
        }
        ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).ifPresent(cap -> {
            float oldBlockRad = cap.getBlockRadiation();
            float newBlockRad = Math.max(0.0f, oldBlockRad + diff);
            cap.setBlockRadiation(newBlockRad);
            chunk.m_8092_(true);
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.debug("[RadSim] Updated block radiation for chunk {}: {} -> {} (diff: {})", new Object[]{chunkPos, Float.valueOf(oldBlockRad), Float.valueOf(newBlockRad), Float.valueOf(diff)});
            }
            if (newBlockRad > 1.0E-6f || cap.getAmbientRadiation() > 1.0E-6f) {
                this.activeChunksByDimension.computeIfAbsent(level.m_46472_().m_135782_(), k -> ConcurrentHashMap.newKeySet()).add(chunkPos);
            }
        });
    }

    private void sendDebugPackets(ServerLevel level) {
        if (!ModClothConfig.get().enableDebugRender) {
            return;
        }
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            boolean isCreativeOrSpectator;
            if (player.m_9236_() != level) continue;
            boolean bl = isCreativeOrSpectator = player.m_7500_() || player.m_5833_();
            if (!ModClothConfig.get().debugRenderInSurvival && !isCreativeOrSpectator) {
                this.lastSentDebugValues.remove(player.m_20148_());
                continue;
            }
            HashMap<ChunkPos, Float> updatesForPlayer = new HashMap<ChunkPos, Float>();
            Map playerLastValues = this.lastSentDebugValues.computeIfAbsent(player.m_20148_(), k -> new HashMap());
            ChunkPos playerChunkPos = player.m_146902_();
            int radius = 4;
            HashSet<ChunkPos> visibleChunks = new HashSet<ChunkPos>();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    float lastSentValue;
                    ChunkPos chunkPos = new ChunkPos(playerChunkPos.f_45578_ + dx, playerChunkPos.f_45579_ + dz);
                    visibleChunks.add(chunkPos);
                    float currentValue = 0.0f;
                    LevelChunk chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                    if (chunk != null) {
                        currentValue = ChunkRadiationHandlerSimple.getChunkRadiationCap(chunk).map(IChunkRadiation::getAmbientRadiation).orElse(Float.valueOf(0.0f)).floatValue();
                    }
                    if (!(Math.abs(currentValue - (lastSentValue = playerLastValues.getOrDefault(chunkPos, Float.valueOf(-1.0f)).floatValue())) > 1.0E-6f)) continue;
                    updatesForPlayer.put(chunkPos, Float.valueOf(currentValue));
                    playerLastValues.put(chunkPos, Float.valueOf(currentValue));
                }
            }
            playerLastValues.entrySet().removeIf(entry -> {
                if (!visibleChunks.contains(entry.getKey())) {
                    if (((Float)entry.getValue()).floatValue() > 0.0f) {
                        updatesForPlayer.put((ChunkPos)entry.getKey(), Float.valueOf(0.0f));
                    }
                    return true;
                }
                return false;
            });
            if (updatesForPlayer.isEmpty()) continue;
            ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ChunkRadiationDebugBatchPacket(updatesForPlayer, level.m_46472_().m_135782_()));
        }
    }

    public void clearPlayerDebugCache(UUID playerUUID) {
        this.lastSentDebugValues.remove(playerUUID);
        if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("Cleared debug radiation cache for player {}", (Object)playerUUID);
        }
    }

    private void handleWorldDestruction(ServerLevel level, ChunkPos pos, float currentRadiation) {
        ModClothConfig config = ModClothConfig.get();
        int baseChecks = config.worldRadEffectsBlockChecks;
        if (baseChecks <= 0) {
            return;
        }
        float normalizedRad = Mth.m_184655_((float)currentRadiation, (float)config.worldRadEffectsThreshold, (float)config.maxRad);
        float scalingFactor = Mth.m_14179_((float)normalizedRad, (float)1.0f, (float)config.worldRadEffectsMaxScaling);
        int actualChecks = Math.max(baseChecks, (int)((float)baseChecks * scalingFactor));
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        block0: for (int i = 0; i < actualChecks; ++i) {
            int startY;
            int x = pos.m_45604_() + level.f_46441_.m_188503_(16);
            int z = pos.m_45605_() + level.f_46441_.m_188503_(16);
            for (int y = startY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z); y >= level.m_141937_(); --y) {
                mutablePos.m_122178_(x, y, z);
                BlockState currentState = level.m_8055_((BlockPos)mutablePos);
                if (currentState.m_60795_()) continue;
                if (currentState.m_60713_(Blocks.f_50752_) || currentState.m_60734_() instanceof RadioactiveBlock) continue block0;
                BlockState newState = null;
                if (currentState.m_60713_(Blocks.f_50440_)) {
                    newState = ((Block)ModBlocks.WASTE_GRASS.get()).m_49966_();
                } else if (currentState.m_204336_(BlockTags.f_13035_)) {
                    newState = level.f_46441_.m_188503_(7) <= 5 ? ((Block)ModBlocks.WASTE_LEAVES.get()).m_49966_() : Blocks.f_50016_.m_49966_();
                } else if (currentState.m_60713_(Blocks.f_50493_)) {
                    // empty if block
                }
                if (newState == null) continue block0;
                level.m_7731_((BlockPos)mutablePos, newState, 2);
                BlockPos posAbove = mutablePos.m_7494_();
                BlockState stateAbove = level.m_8055_(posAbove);
                if (!stateAbove.m_60713_(Blocks.f_50359_) && !stateAbove.m_60713_(Blocks.f_50034_) && !stateAbove.m_204336_(BlockTags.f_13041_) && !stateAbove.m_60713_(Blocks.f_50125_)) continue block0;
                level.m_7731_(posAbove, Blocks.f_50016_.m_49966_(), 2);
                continue block0;
            }
        }
    }

    @Override
    public void clearSystem(Level level) {
    }
}

