/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.radiation;

import com.hbm_m.config.ModClothConfig;
import com.hbm_m.hazard.HazardSystem;
import com.hbm_m.hazard.HazardType;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.radiation.ChunkRadiationHandler;
import com.hbm_m.radiation.ChunkRadiationHandlerPRISM;
import com.hbm_m.radiation.ChunkRadiationHandlerSimple;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkRadiationManager {
    public static final ChunkRadiationManager INSTANCE = new ChunkRadiationManager();
    private static ChunkRadiationHandler proxyInstance;
    private int tickCounter = 0;

    private ChunkRadiationManager() {
    }

    public static ChunkRadiationHandler getProxy() {
        if (proxyInstance == null) {
            proxyInstance = ModClothConfig.get().usePrismSystem ? new ChunkRadiationHandlerPRISM() : new ChunkRadiationHandlerSimple();
        }
        return proxyInstance;
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        if (ModClothConfig.get().enableChunkRads) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("World load event received for {}", (Object)level.m_46472_().m_135782_());
                }
            }
            ChunkRadiationManager.getProxy().receiveWorldLoad(event);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (ModClothConfig.get().enableChunkRads) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("World unload event received for {}", (Object)level.m_46472_().m_135782_());
                }
            }
            ChunkRadiationManager.getProxy().receiveWorldUnload(event);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess;
        if (ModClothConfig.get().enableChunkRads && !event.getLevel().m_5776_() && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            ChunkRadiationManager.getProxy().receiveChunkLoad(chunk);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (ModClothConfig.get().enableChunkRads) {
            ChunkRadiationManager.getProxy().receiveChunkUnload(event);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!ModClothConfig.get().enableRadiation || !ModClothConfig.get().enableChunkRads || event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            ChunkRadiationManager.getProxy().updateSystem();
            this.tickCounter = 0;
            if (ModClothConfig.get().worldRadEffects) {
                ChunkRadiationManager.getProxy().handleWorldDestruction();
            }
        }
        ChunkRadiationManager.getProxy().receiveWorldTick(event);
    }

    private float getRadFromState(BlockState state) {
        if (state.m_60795_()) {
            return 0.0f;
        }
        ItemStack blockAsStack = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        return HazardSystem.getHazardLevelFromStack(blockAsStack, HazardType.RADIATION);
    }

    private void handleBlockChange(BlockState oldState, BlockState newState, LevelAccessor level, BlockPos pos) {
        if (level.m_5776_() || !(level instanceof Level)) {
            return;
        }
        Level world = (Level)level;
        float oldRad = this.getRadFromState(oldState);
        float newRad = this.getRadFromState(newState);
        float diff = newRad - oldRad;
        if (Math.abs(diff) > 1.0E-6f) {
            ChunkRadiationManager.getProxy().incrementBlockRadiation(world, pos, diff);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockSnapshot snapshot = event.getBlockSnapshot();
        BlockState oldState = snapshot.getReplacedBlock();
        BlockState newState = event.getState();
        this.handleBlockChange(oldState, newState, event.getLevel(), event.getPos());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        this.handleBlockChange(event.getState(), Blocks.f_50016_.m_49966_(), event.getLevel(), event.getPos());
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        for (BlockPos pos : event.getAffectedBlocks()) {
            BlockState oldState = level.m_8055_(pos);
            this.handleBlockChange(oldState, Blocks.f_50016_.m_49966_(), (LevelAccessor)level, pos);
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ChunkRadiationHandler chunkRadiationHandler = ChunkRadiationManager.getProxy();
        if (chunkRadiationHandler instanceof ChunkRadiationHandlerSimple) {
            ChunkRadiationHandlerSimple handler = (ChunkRadiationHandlerSimple)chunkRadiationHandler;
            handler.clearPlayerDebugCache(event.getEntity().m_20148_());
        }
    }

    public static float getRadiation(Level level, int x, int y, int z) {
        if (!ModClothConfig.get().enableRadiation || !ModClothConfig.get().enableChunkRads) {
            return 0.0f;
        }
        return ChunkRadiationManager.getProxy().getRadiation(level, x, y, z);
    }

    public static void setRadiation(Level level, int x, int y, int z, float rad) {
        if (!ModClothConfig.get().enableRadiation || !ModClothConfig.get().enableChunkRads) {
            return;
        }
        ChunkRadiationManager.getProxy().setRadiation(level, x, y, z, rad);
    }

    public static void incrementRad(Level level, int x, int y, int z, float rad) {
        if (!ModClothConfig.get().enableRadiation || !ModClothConfig.get().enableChunkRads) {
            return;
        }
        ChunkRadiationManager.getProxy().incrementRad(level, x, y, z, rad);
    }
}

