/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.radiation;

import com.hbm_m.armormod.util.ArmorModificationHelper;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.client.render.shader.ShaderCompatibilityDetector;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.damagesource.ModDamageSources;
import com.hbm_m.hazard.HazardSystem;
import com.hbm_m.hazard.HazardType;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.RadiationDataPacket;
import com.hbm_m.radiation.ChunkRadiationManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;

public class PlayerHandler {
    private static final HashMap<UUID, Float> playerRads = new HashMap();
    private static final String NBT_KEY_PLAYER_RADIATION = "hbm_m_player_radiation";
    private int tickCounter = 0;

    public static float getPlayerRads(Player player) {
        if (player == null) {
            return 0.0f;
        }
        UUID uuid = player.m_20148_();
        Float rad = playerRads.get(uuid);
        return rad != null ? rad.floatValue() : 0.0f;
    }

    public static void setPlayerRads(Player player, float rads) {
        if (player == null) {
            return;
        }
        UUID uuid = player.m_20148_();
        float clamped = (float)Math.round(Math.max(0.0f, rads) * 10.0f) / 10.0f;
        playerRads.put(uuid, Float.valueOf(clamped));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8906_ != null) {
                float environmentRad = ChunkRadiationManager.getRadiation(serverPlayer.m_9236_(), serverPlayer.m_20183_().m_123341_(), serverPlayer.m_20183_().m_123342_(), serverPlayer.m_20183_().m_123343_());
                ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RadiationDataPacket(environmentRad, clamped));
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("SERVER: Sent RadiationDataPacket (from setPlayerRads) to player {} with EnvRad: {}, PlayerRad: {}", new Object[]{player.m_7755_().getString(), Float.valueOf(environmentRad), Float.valueOf(clamped)});
                }
            }
        }
    }

    public static void incrementPlayerRads(Player player, float rads) {
        if (player == null || rads <= 0.0f) {
            return;
        }
        PlayerHandler.setPlayerRads(player, PlayerHandler.getPlayerRads(player) + rads);
    }

    public static void decrementPlayerRads(Player player, float rads) {
        if (player == null || rads <= 0.0f) {
            return;
        }
        PlayerHandler.setPlayerRads(player, Math.max(0.0f, PlayerHandler.getPlayerRads(player) - rads));
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            CompoundTag persistentData = player.getPersistentData();
            float rads = 0.0f;
            if (persistentData.m_128441_(NBT_KEY_PLAYER_RADIATION)) {
                CompoundTag data = persistentData.m_128469_(NBT_KEY_PLAYER_RADIATION);
                rads = (float)Math.round(data.m_128457_("radiationLevel") * 10.0f) / 10.0f;
            }
            PlayerHandler.setPlayerRads(player, rads);
            MainRegistry.LOGGER.debug("Loaded radiation data for player {}: {} RAD", (Object)player.m_7755_().getString(), (Object)Float.valueOf(rads));
        }
    }

    @SubscribeEvent
    public void onPlayerSave(PlayerEvent.SaveToFile event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            CompoundTag persistentData = player.getPersistentData();
            CompoundTag data = new CompoundTag();
            float rounded = (float)Math.round(PlayerHandler.getPlayerRads(player) * 10.0f) / 10.0f;
            data.m_128350_("radiationLevel", rounded);
            persistentData.m_128365_(NBT_KEY_PLAYER_RADIATION, (Tag)data);
            MainRegistry.LOGGER.debug("Saving radiation data for player {}: {} RAD", (Object)player.m_7755_().getString(), (Object)Float.valueOf(rounded));
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        playerRads.remove(player.m_20148_());
    }

    public static float getInventoryRadiation(Player player) {
        float totalRads = 0.0f;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            totalRads += PlayerHandler.getRadiationFromItemStack(stack);
        }
        for (ItemStack stack : player.m_150109_().f_35975_) {
            totalRads += PlayerHandler.getRadiationFromItemStack(stack);
        }
        ItemStack offhand = player.m_21206_();
        return totalRads += PlayerHandler.getRadiationFromItemStack(offhand);
    }

    private static float getRadiationFromItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        float perItemRadiation = HazardSystem.getHazardLevelFromStack(stack, HazardType.RADIATION);
        return perItemRadiation * (float)stack.m_41613_();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21224_()) {
            PlayerHandler.setPlayerRads(event.player, 0.0f);
            return;
        }
        if (!ModClothConfig.get().enableRadiation || event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            float totalRad = 0.0f;
            if (!player.m_7500_() && !player.m_5833_()) {
                float chunkRad = 0.0f;
                float invRad = 0.0f;
                if (ModClothConfig.get().enableChunkRads) {
                    chunkRad = ChunkRadiationManager.getRadiation(player.m_9236_(), player.m_20183_().m_123341_(), player.m_20183_().m_123342_(), player.m_20183_().m_123343_());
                }
                if (ModClothConfig.get().enableRadiation) {
                    invRad = PlayerHandler.getInventoryRadiation(player);
                }
                totalRad = chunkRad + invRad;
                float totalAbsoluteProtection = 0.0f;
                for (ItemStack armorStack : player.m_6168_()) {
                    totalAbsoluteProtection += ArmorModificationHelper.getTotalAbsoluteRadProtection(armorStack);
                }
                float protectionPercent = ArmorModificationHelper.convertAbsoluteToPercent(totalAbsoluteProtection);
                float resultingRad = totalRad * (1.0f - protectionPercent);
                if (resultingRad > 0.0f) {
                    PlayerHandler.incrementPlayerRads(player, resultingRad);
                    if (ModClothConfig.get().enableDebugLogging) {
                        MainRegistry.LOGGER.debug("Add total radiation to player {}: chunk={} inv={} total={} prot={} final={}", new Object[]{player.m_7755_().getString(), Float.valueOf(chunkRad), Float.valueOf(invRad), Float.valueOf(totalRad), String.format("%.2f%%", Float.valueOf(protectionPercent * 100.0f)), Float.valueOf(resultingRad)});
                    }
                }
                PlayerHandler.decrementPlayerRads(player, ModClothConfig.get().radDecay);
                this.applyRadiationEffects(player);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                float currentAccumulatedRads = PlayerHandler.getPlayerRads(player);
                float incomingRadForPacket = totalRad;
                ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RadiationDataPacket(incomingRadForPacket, currentAccumulatedRads));
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("SERVER: Sending periodic RadiationDataPacket to player {}. EnvRad (Incoming): {}, PlayerRad (Accumulated): {}", new Object[]{player.m_7755_().getString(), Float.valueOf(incomingRadForPacket), Float.valueOf(currentAccumulatedRads)});
                }
            }
        }
    }

    private void applyRadiationEffects(Player player) {
        ServerPlayer serverPlayer;
        MinecraftServer server;
        float rads = PlayerHandler.getPlayerRads(player);
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).m_20194_()) != null) {
            AdvancementProgress progress;
            Advancement rad1000Advancement;
            AdvancementProgress progress2;
            ServerAdvancementManager advancementManager = server.m_129889_();
            Advancement rad200Advancement = advancementManager.m_136041_(ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"radiation_200"));
            if (rad200Advancement != null && !(progress2 = serverPlayer.m_8960_().m_135996_(rad200Advancement)).m_8193_()) {
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("SERVER: Checking radiation_200 advancement for player {}. Current rads: {}, isDone: {}", new Object[]{serverPlayer.m_7755_().getString(), Float.valueOf(rads), progress2.m_8193_()});
                }
                if (rads >= 200.0f) {
                    for (String criterion : progress2.m_8219_()) {
                        serverPlayer.m_8960_().m_135988_(rad200Advancement, criterion);
                        if (!ModClothConfig.get().enableDebugLogging) continue;
                        MainRegistry.LOGGER.info("SERVER: Awarded radiation_200 advancement to player {} for criterion {}", (Object)serverPlayer.m_7755_().getString(), (Object)criterion);
                    }
                }
            }
            if ((rad1000Advancement = advancementManager.m_136041_(ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"radiation_1000"))) != null && !(progress = serverPlayer.m_8960_().m_135996_(rad1000Advancement)).m_8193_()) {
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("SERVER: Checking radiation_1000 advancement for player {}. Current rads: {}, isDone: {}", new Object[]{serverPlayer.m_7755_().getString(), Float.valueOf(rads), progress.m_8193_()});
                }
                if (rads >= ModClothConfig.get().maxPlayerRad) {
                    for (String criterion : progress.m_8219_()) {
                        serverPlayer.m_8960_().m_135988_(rad1000Advancement, criterion);
                        if (!ModClothConfig.get().enableDebugLogging) continue;
                        MainRegistry.LOGGER.info("SERVER: Awarded radiation_1000 advancement to player {} for criterion {}", (Object)serverPlayer.m_7755_().getString(), (Object)criterion);
                    }
                }
            }
        }
        if (rads >= ModClothConfig.get().maxPlayerRad) {
            MainRegistry.LOGGER.debug("SERVER: Player {} radiation ({}) reached maxPlayerRad ({}). Killing player and resetting radiation.", new Object[]{player.m_7755_().getString(), Float.valueOf(rads), Float.valueOf(ModClothConfig.get().maxPlayerRad)});
            player.m_6469_(ModDamageSources.radiation(player.m_9236_()), Float.MAX_VALUE);
            PlayerHandler.setPlayerRads(player, 0.0f);
            return;
        }
        if (rads > ModClothConfig.get().radDamageThreshold) {
            player.m_6469_(player.m_269291_().m_269425_(), ModClothConfig.get().radDamage);
        }
        if (rads > (float)ModClothConfig.get().radBlindness) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 220, 0));
        }
        if (rads > (float)ModClothConfig.get().radConfusion) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 220, 0));
        }
        if (rads > (float)ModClothConfig.get().radWater) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 220, 2));
        }
        if (rads > (float)ModClothConfig.get().radSickness) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 220, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 220, 0));
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"hbm_m").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rad").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82127_((String)"clear").executes(ctx -> {
            Collection targets = EntityArgument.m_91461_((CommandContext)ctx, (String)"targets");
            int[] count = new int[]{0};
            for (Entity e : targets) {
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                PlayerHandler.setPlayerRads(p, 0.0f);
                count[0] = count[0] + 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.hbm_m.rad.cleared", (Object[])new Object[]{count[0]}), true);
            return count[0];
        }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91461_((CommandContext)ctx, (String)"targets");
            int[] count = new int[]{0};
            for (Entity e : targets) {
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                PlayerHandler.incrementPlayerRads(p, amount);
                count[0] = count[0] + 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.hbm_m.rad.added", (Object[])new Object[]{Float.valueOf(amount), count[0]}), true);
            return count[0];
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            Collection targets = EntityArgument.m_91461_((CommandContext)ctx, (String)"targets");
            int[] count = new int[]{0};
            for (Entity e : targets) {
                if (!(e instanceof Player)) continue;
                Player p = (Player)e;
                PlayerHandler.decrementPlayerRads(p, amount);
                count[0] = count[0] + 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.hbm_m.rad.removed", (Object[])new Object[]{Float.valueOf(amount), count[0]}), true);
            return count[0];
        }))))).then(Commands.m_82127_((String)"clear").executes(ctx -> {
            Entity self = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (self instanceof Player) {
                Player p = (Player)self;
                PlayerHandler.setPlayerRads(p, 0.0f);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.hbm_m.rad.cleared.self"), true);
                return 1;
            }
            return 0;
        }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            Entity self = ((CommandSourceStack)ctx.getSource()).m_81373_();
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            if (self instanceof Player) {
                Player p = (Player)self;
                PlayerHandler.incrementPlayerRads(p, amount);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.hbm_m.rad.added.self", (Object[])new Object[]{Float.valueOf(amount)}), true);
                return 1;
            }
            return 0;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            Entity self = ((CommandSourceStack)ctx.getSource()).m_81373_();
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            if (self instanceof Player) {
                Player p = (Player)self;
                PlayerHandler.decrementPlayerRads(p, amount);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.hbm_m.rad.removed.self", (Object[])new Object[]{Float.valueOf(amount)}), true);
                return 1;
            }
            return 0;
        })))));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            PlayerHandler.registerClientRenderCommands(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerClientRenderCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"hbm_m").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"render").then(Commands.m_82127_((String)"toggle").executes(context -> PlayerHandler.executeClientRenderToggle((CommandContext<CommandSourceStack>)context)))).then(Commands.m_82127_((String)"status").executes(context -> PlayerHandler.executeClientRenderStatus((CommandContext<CommandSourceStack>)context)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int executeClientRenderToggle(CommandContext<CommandSourceStack> context) {
        try {
            RenderPathManager.RenderPath current = RenderPathManager.getCurrentPath();
            boolean shaderActive = ShaderCompatibilityDetector.isExternalShaderActive();
            if (current == RenderPathManager.RenderPath.IMMEDIATE_FALLBACK && shaderActive) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7c[HBM] \u00a77Cannot switch to VBO mode: External shader is active!\n\u00a77VBO rendering is incompatible with shader packs.\n\u00a77Please disable the shader pack first."));
                return 0;
            }
            RenderPathManager.RenderPath newPath = current == RenderPathManager.RenderPath.VBO_OPTIMIZED ? RenderPathManager.RenderPath.IMMEDIATE_FALLBACK : RenderPathManager.RenderPath.VBO_OPTIMIZED;
            RenderPathManager.forceSetPath(newPath);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[HBM] \u00a77Render path set to: \u00a7f" + String.valueOf((Object)newPath))), false);
            return 1;
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error executing render toggle command", (Throwable)e);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[HBM] \u00a77Error: " + e.getMessage())));
            return 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int executeClientRenderStatus(CommandContext<CommandSourceStack> context) {
        try {
            RenderPathManager.RenderPath current = RenderPathManager.getCurrentPath();
            boolean shaderActive = ShaderCompatibilityDetector.isExternalShaderActive();
            String statusMessage = String.format("\u00a7e[HBM] \u00a77Render Status:\n\u00a77\u251c\u2500 Current path: \u00a7f%s\n\u00a77\u251c\u2500 External shader: \u00a7f%s\n\u00a77\u2514\u2500 VBO available: \u00a7f%s", new Object[]{current, shaderActive ? "\u00a7aActive" : "\u00a7cInactive", shaderActive ? "\u00a7cNo (incompatible)" : "\u00a7aYes"});
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)statusMessage), false);
            return 1;
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error executing render status command", (Throwable)e);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[HBM] \u00a77Error: " + e.getMessage())));
            return 0;
        }
    }
}

