/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.hbm_m.block.AnvilTier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class AnvilRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack inputA;
    private final ItemStack inputB;
    private final boolean consumeA;
    private final boolean consumeB;
    private final List<ItemStack> inventoryInputs;
    private final List<ResultEntry> outputs;
    private final ItemStack displayStack;
    private final AnvilTier requiredTier;
    @Nullable
    private final AnvilTier upperTier;
    @Nullable
    private final String blueprintPool;
    private final OverlayType overlay;

    public AnvilRecipe(ResourceLocation id, ItemStack inputA, ItemStack inputB, List<ItemStack> inventoryInputs, List<ResultEntry> outputs, AnvilTier requiredTier, @Nullable AnvilTier upperTier, @Nullable String blueprintPool, OverlayType overlay, boolean consumeA, boolean consumeB) {
        this.id = id;
        this.inputA = inputA == null ? ItemStack.f_41583_ : inputA;
        this.inputB = inputB == null ? ItemStack.f_41583_ : inputB;
        this.consumeA = consumeA;
        this.consumeB = consumeB;
        this.inventoryInputs = Collections.unmodifiableList(new ArrayList<ItemStack>(inventoryInputs));
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Anvil recipe " + String.valueOf(id) + " must define at least one output");
        }
        this.outputs = Collections.unmodifiableList(new ArrayList<ResultEntry>(outputs));
        this.displayStack = this.computeDisplayStack();
        this.requiredTier = requiredTier;
        this.upperTier = upperTier;
        this.blueprintPool = blueprintPool;
        this.overlay = overlay;
    }

    public boolean m_5818_(Container container, Level level) {
        if (container.m_6643_() < 2) {
            return false;
        }
        if (!this.usesMachineInputs()) {
            return false;
        }
        return this.matches(container.m_8020_(0), container.m_8020_(1));
    }

    public boolean matches(ItemStack slotA, ItemStack slotB) {
        if (!this.usesMachineInputs()) {
            return false;
        }
        return this.matchesExact(slotA, slotB) || this.matchesExact(slotB, slotA);
    }

    private boolean matchesExact(ItemStack slotA, ItemStack slotB) {
        return ItemStack.m_150942_((ItemStack)slotA, (ItemStack)this.inputA) && ItemStack.m_150942_((ItemStack)slotB, (ItemStack)this.inputB) && slotA.m_41613_() >= this.inputA.m_41613_() && slotB.m_41613_() >= this.inputB.m_41613_();
    }

    public boolean canCraftOn(AnvilTier tier) {
        int min;
        int current = tier.getLegacyId();
        if (current < (min = this.requiredTier.getLegacyId())) {
            return false;
        }
        if (this.upperTier != null) {
            return current <= this.upperTier.getLegacyId();
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.outputs.get(0).stack().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack getInputA() {
        return this.inputA;
    }

    public ItemStack getInputB() {
        return this.inputB;
    }

    public boolean consumesA() {
        return this.consumeA;
    }

    public boolean consumesB() {
        return this.consumeB;
    }

    public List<ItemStack> getRequiredItems() {
        return this.inventoryInputs;
    }

    public List<ItemStack> getInventoryInputs() {
        return this.inventoryInputs;
    }

    public List<ResultEntry> getOutputs() {
        return this.outputs;
    }

    public AnvilTier getRequiredTier() {
        return this.requiredTier;
    }

    @Nullable
    public String getBlueprintPool() {
        return this.blueprintPool;
    }

    public boolean requiresBlueprint() {
        return this.blueprintPool != null && !this.blueprintPool.isEmpty();
    }

    public OverlayType getOverlay() {
        return this.overlay;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack.m_41777_();
    }

    public boolean usesMachineInputs() {
        return !this.inputA.m_41619_() || !this.inputB.m_41619_();
    }

    public boolean isRecycling() {
        return this.overlay == OverlayType.RECYCLING;
    }

    public ItemStack getRecyclingInputStack() {
        if (!this.isRecycling()) {
            return ItemStack.f_41583_;
        }
        if (!this.inventoryInputs.isEmpty()) {
            return this.inventoryInputs.get(0).m_41777_();
        }
        if (!this.inputA.m_41619_()) {
            return this.inputA.m_41777_();
        }
        if (!this.inputB.m_41619_()) {
            return this.inputB.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private ItemStack computeDisplayStack() {
        if (this.overlay == OverlayType.RECYCLING) {
            if (!this.inventoryInputs.isEmpty()) {
                return this.inventoryInputs.get(0).m_41777_();
            }
            if (!this.inputA.m_41619_()) {
                return this.inputA.m_41777_();
            }
        }
        if (!this.outputs.isEmpty()) {
            return this.outputs.get(0).stack().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static enum OverlayType {
        NONE,
        CONSTRUCTION,
        RECYCLING,
        SMITHING;


        private static OverlayType byName(String name) {
            for (OverlayType type : OverlayType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NONE;
        }
    }

    public record ResultEntry(ItemStack stack, float chance) {
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public AnvilRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray reqArray;
            ItemStack inputA = json.has("input_a") ? Serializer.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"input_a")) : ItemStack.f_41583_;
            ItemStack inputB = json.has("input_b") ? Serializer.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"input_b")) : ItemStack.f_41583_;
            boolean consumeA = GsonHelper.m_13855_((JsonObject)json, (String)"consume_a", (boolean)true);
            boolean consumeB = GsonHelper.m_13855_((JsonObject)json, (String)"consume_b", (boolean)true);
            ArrayList<ItemStack> inventoryInputs = new ArrayList<ItemStack>();
            if (json.has("required_items")) {
                reqArray = GsonHelper.m_13933_((JsonObject)json, (String)"required_items");
                reqArray.forEach(element -> inventoryInputs.add(Serializer.itemStackFromJson(element.getAsJsonObject())));
            }
            if (json.has("inventory_inputs")) {
                reqArray = GsonHelper.m_13933_((JsonObject)json, (String)"inventory_inputs");
                reqArray.forEach(element -> inventoryInputs.add(Serializer.itemStackFromJson(element.getAsJsonObject())));
            }
            ArrayList<ResultEntry> outputs = new ArrayList<ResultEntry>();
            if (json.has("outputs")) {
                JsonArray outArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
                outArray.forEach(element -> outputs.add(Serializer.outputFromJson(element.getAsJsonObject())));
            } else if (json.has("output")) {
                ItemStack output = Serializer.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
                float chance = Mth.m_14036_((float)GsonHelper.m_13820_((JsonObject)json, (String)"output_chance", (float)1.0f), (float)0.0f, (float)1.0f);
                outputs.add(new ResultEntry(output, chance));
            }
            String tierName = GsonHelper.m_13851_((JsonObject)json, (String)"tier", (String)"iron");
            AnvilTier tier = AnvilTier.valueOf(tierName.toUpperCase(Locale.ROOT));
            AnvilTier upper = null;
            if (json.has("tier_upper")) {
                upper = AnvilTier.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"tier_upper").toUpperCase(Locale.ROOT));
            }
            String blueprintPool = GsonHelper.m_13851_((JsonObject)json, (String)"blueprint_pool", null);
            OverlayType overlay = OverlayType.byName(GsonHelper.m_13851_((JsonObject)json, (String)"overlay", (String)"none"));
            return new AnvilRecipe(id, inputA, inputB, inventoryInputs, outputs, tier, upper, blueprintPool, overlay, consumeA, consumeB);
        }

        public AnvilRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStack inputA = buffer.m_130267_();
            ItemStack inputB = buffer.m_130267_();
            boolean consumeA = buffer.readBoolean();
            boolean consumeB = buffer.readBoolean();
            int size = buffer.readInt();
            ArrayList<ItemStack> inventoryInputs = new ArrayList<ItemStack>();
            for (int i = 0; i < size; ++i) {
                inventoryInputs.add(buffer.m_130267_());
            }
            int outputsSize = buffer.readInt();
            ArrayList<ResultEntry> outputs = new ArrayList<ResultEntry>();
            for (int i = 0; i < outputsSize; ++i) {
                ItemStack stack = buffer.m_130267_();
                float chance = buffer.readFloat();
                outputs.add(new ResultEntry(stack, chance));
            }
            AnvilTier tier = AnvilTier.values()[buffer.m_130242_()];
            AnvilTier upper = null;
            int upperVal = buffer.m_130242_();
            if (upperVal >= 0 && upperVal < AnvilTier.values().length) {
                upper = AnvilTier.values()[upperVal];
            }
            String blueprintPool = buffer.readBoolean() ? buffer.m_130277_() : null;
            OverlayType overlay = OverlayType.values()[buffer.m_130242_()];
            return new AnvilRecipe(id, inputA, inputB, inventoryInputs, outputs, tier, upper, blueprintPool, overlay, consumeA, consumeB);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilRecipe recipe) {
            buffer.m_130055_(recipe.inputA);
            buffer.m_130055_(recipe.inputB);
            buffer.writeBoolean(recipe.consumeA);
            buffer.writeBoolean(recipe.consumeB);
            buffer.writeInt(recipe.inventoryInputs.size());
            for (ItemStack item : recipe.inventoryInputs) {
                buffer.m_130055_(item);
            }
            buffer.writeInt(recipe.outputs.size());
            for (ResultEntry entry : recipe.outputs) {
                buffer.m_130055_(entry.stack());
                buffer.writeFloat(entry.chance());
            }
            buffer.m_130130_(recipe.requiredTier.ordinal());
            buffer.m_130130_(recipe.upperTier != null ? recipe.upperTier.ordinal() : -1);
            if (recipe.blueprintPool != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.blueprintPool);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130130_(recipe.overlay.ordinal());
        }

        private static ItemStack itemStackFromJson(JsonObject object) {
            return ShapedRecipe.m_151274_((JsonObject)object);
        }

        private static ResultEntry outputFromJson(JsonObject object) {
            ItemStack stack = Serializer.itemStackFromJson(object);
            float chance = 1.0f;
            if (object.has("chance")) {
                chance = Mth.m_14036_((float)GsonHelper.m_13915_((JsonObject)object, (String)"chance"), (float)0.0f, (float)1.0f);
            }
            return new ResultEntry(stack, chance);
        }
    }

    public static class Type
    implements RecipeType<AnvilRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "anvil";
    }
}

