/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.recipe;

import com.hbm_m.block.AnvilTier;
import com.hbm_m.recipe.AnvilRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class AnvilRecipeManager {
    private AnvilRecipeManager() {
    }

    public static List<AnvilRecipe> getAllRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)AnvilRecipe.Type.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<AnvilRecipe> getClientRecipes() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        return level != null ? AnvilRecipeManager.getAllRecipes((Level)level) : Collections.emptyList();
    }

    public static List<AnvilRecipe> searchRecipes(Level level, String query) {
        List<AnvilRecipe> recipes = AnvilRecipeManager.getAllRecipes(level);
        if (query == null || query.trim().isEmpty()) {
            return recipes;
        }
        String lowerQuery = query.toLowerCase(Locale.ROOT);
        RegistryAccess access = level.m_9598_();
        return recipes.stream().filter(recipe -> {
            ItemStack output = recipe.m_8043_(access);
            String itemName = output.m_41786_().getString().toLowerCase(Locale.ROOT);
            return itemName.contains(lowerQuery);
        }).collect(Collectors.toList());
    }

    public static Optional<AnvilRecipe> findRecipe(Level level, ItemStack slotA, ItemStack slotB, AnvilTier tier) {
        return level.m_7465_().m_44013_((RecipeType)AnvilRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.matches(slotA, slotB) && recipe.canCraftOn(tier)).findFirst();
    }

    public static Optional<AnvilRecipe> getRecipe(Level level, ResourceLocation id) {
        return level.m_7465_().m_44013_((RecipeType)AnvilRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.m_6423_().equals((Object)id)).findFirst();
    }
}

