/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class AssemblerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final int duration;
    private final int powerConsumption;
    @Nullable
    private final String blueprintPool;

    public AssemblerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int duration, int power) {
        this(id, output, recipeItems, duration, power, null);
    }

    public AssemblerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int duration, int power, @Nullable String blueprintPool) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.duration = duration;
        this.powerConsumption = power;
        this.blueprintPool = blueprintPool;
    }

    public boolean matches(@Nonnull SimpleContainer pContainer, @Nonnull Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        StackedContents stackedcontents = new StackedContents();
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack itemstack = pContainer.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            stackedcontents.m_36491_(itemstack);
        }
        return stackedcontents.m_36475_((Recipe)this, null);
    }

    public ItemStack assemble(@Nonnull SimpleContainer pContainer, @Nonnull RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getPowerConsumption() {
        return this.powerConsumption;
    }

    @Nullable
    public String getBlueprintPool() {
        return this.blueprintPool;
    }

    public boolean requiresBlueprint() {
        return this.blueprintPool != null && !this.blueprintPool.isEmpty();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<AssemblerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"assembler");

        public AssemblerRecipe fromJson(@Nonnull ResourceLocation pRecipeId, @Nonnull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < ingredientsJson.size(); ++i) {
                JsonObject ingredientObject = ingredientsJson.get(i).getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientObject);
                int count = GsonHelper.m_13824_((JsonObject)ingredientObject, (String)"count", (int)1);
                for (int j = 0; j < count; ++j) {
                    inputs.add((Object)ingredient);
                }
            }
            int duration = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"duration", (int)100);
            int power = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"power", (int)1000);
            String blueprintPool = GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"blueprint_pool", null);
            return new AssemblerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs, duration, power, blueprintPool);
        }

        @Nullable
        public AssemblerRecipe fromNetwork(@Nonnull ResourceLocation pRecipeId, @Nonnull FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            int duration = pBuffer.readInt();
            int power = pBuffer.readInt();
            String blueprintPool = pBuffer.readBoolean() ? pBuffer.m_130277_() : null;
            return new AssemblerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs, duration, power, blueprintPool);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, @Nonnull AssemblerRecipe pRecipe) {
            pBuffer.m_130130_(pRecipe.recipeItems.size());
            for (Ingredient ing : pRecipe.recipeItems) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.m_8043_(null));
            pBuffer.writeInt(pRecipe.getDuration());
            pBuffer.writeInt(pRecipe.getPowerConsumption());
            if (pRecipe.blueprintPool != null) {
                pBuffer.writeBoolean(true);
                pBuffer.m_130070_(pRecipe.blueprintPool);
            } else {
                pBuffer.writeBoolean(false);
            }
        }
    }

    public static class Type
    implements RecipeType<AssemblerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "assembler";
    }
}

