/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlastExplosionGenerator {
    private static final float BASE_HARDNESS_THRESHOLD = 3.0f;
    private static final float MAX_HARDNESS_THRESHOLD = 50.0f;
    private static final int DEBRIS_COUNT_MULTIPLIER = 6;
    private static final int FLYING_DEBRIS_COUNT = 200;
    private static final float BASE_EXPLOSION_DAMAGE = 25.0f;
    private static final float DAMAGE_FALLOFF = 0.6f;

    public static void generateNaturalCrater(ServerLevel level, BlockPos centerPos, int radius, int depth) {
        RandomSource random = level.f_46441_;
        ArrayList<CraterData> craterBlocks = new ArrayList<CraterData>();
        HashSet<BlockPos> debrisPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> aboveGroundBlocks = new HashSet<BlockPos>();
        BlastExplosionGenerator.calculateNaturalCraterShape(level, centerPos, radius, depth, random, craterBlocks);
        BlastExplosionGenerator.calculateAboveGroundDestruction(level, centerPos, radius, random, aboveGroundBlocks);
        BlastExplosionGenerator.generateDebrisField(level, centerPos, radius, depth, random, debrisPositions);
        BlastExplosionGenerator.startCraterGeneration(level, centerPos, craterBlocks, debrisPositions, aboveGroundBlocks, radius, depth);
    }

    private static void calculateNaturalCraterShape(ServerLevel level, BlockPos centerPos, int radius, int depth, RandomSource random, List<CraterData> craterBlocks) {
        int mapSize = radius * 2 + 10;
        double[][] noiseMap = BlastExplosionGenerator.generatePerlinNoise(mapSize, mapSize, random);
        for (int x = -radius - 5; x <= radius + 5; ++x) {
            for (int z = -radius - 5; z <= radius + 5; ++z) {
                int noiseZ;
                int noiseX;
                double noiseValue;
                double modifiedRadius;
                double horizontalDistance = Math.sqrt(x * x + z * z);
                if (horizontalDistance <= (modifiedRadius = (double)radius + ((noiseValue = noiseMap[noiseX = Math.min(mapSize - 1, Math.max(0, x + radius + 5))][noiseZ = Math.min(mapSize - 1, Math.max(0, z + radius + 5))]) - 0.5) * (double)radius * 0.25)) {
                    int localDepth = BlastExplosionGenerator.calculateParabolicDepth(horizontalDistance, modifiedRadius, depth, noiseValue);
                    for (int y = 0; y >= -localDepth; --y) {
                        BlockPos checkPos = centerPos.m_7918_(x, y, z);
                        if (!BlastExplosionGenerator.shouldDestroyBlock(level, checkPos, horizontalDistance, modifiedRadius, y, localDepth, random)) continue;
                        CraterData craterData = new CraterData(checkPos, BlastExplosionGenerator.calculateDestructionDelay(horizontalDistance, modifiedRadius), horizontalDistance < modifiedRadius * 0.65);
                        craterBlocks.add(craterData);
                    }
                }
                if (!(horizontalDistance > modifiedRadius * 0.7) || !(horizontalDistance <= modifiedRadius * 1.3)) continue;
                double rimHeight = BlastExplosionGenerator.calculateRimHeight(horizontalDistance, modifiedRadius, radius, noiseValue);
                for (int y = 1; y <= (int)rimHeight; ++y) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    if (!(random.m_188501_() < 0.65f)) continue;
                    CraterData craterData = new CraterData(checkPos, BlastExplosionGenerator.calculateDestructionDelay(horizontalDistance, modifiedRadius), false);
                    craterBlocks.add(craterData);
                }
            }
        }
        craterBlocks.sort(Comparator.comparingInt(CraterData::getDelay));
    }

    private static void calculateAboveGroundDestruction(ServerLevel level, BlockPos centerPos, int radius, RandomSource random, Set<BlockPos> aboveGroundBlocks) {
        int verticalRadius = radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 1; y <= verticalRadius; ++y) {
                    BlockState state;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)radius)) continue;
                    float destructionChance = Math.max(0.3f, 1.0f - (float)(distance / (double)radius));
                    if (!(random.m_188501_() < destructionChance) || (state = level.m_8055_(checkPos)).m_60795_() || state.m_60713_(Blocks.f_50752_)) continue;
                    aboveGroundBlocks.add(checkPos);
                }
            }
        }
    }

    private static void generateDebrisField(ServerLevel level, BlockPos centerPos, int radius, int depth, RandomSource random, Set<BlockPos> debrisPositions) {
        int debrisCount = radius * 6;
        int debrisRadius = (int)((double)radius * 1.8);
        for (int i = 0; i < debrisCount; ++i) {
            int z;
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double distance = (double)radius * 0.8 + random.m_188500_() * (double)debrisRadius;
            int x = (int)(Math.cos(angle) * distance);
            BlockPos surfacePos = BlastExplosionGenerator.findSurfacePosition(level, centerPos.m_7918_(x, 0, z = (int)(Math.sin(angle) * distance)));
            if (surfacePos == null || !(random.m_188501_() < 0.5f)) continue;
            debrisPositions.add(surfacePos);
        }
    }

    private static void startCraterGeneration(ServerLevel level, BlockPos centerPos, List<CraterData> craterBlocks, Set<BlockPos> debrisPositions, Set<BlockPos> aboveGroundBlocks, int radius, int depth) {
        HashMap<Integer, List<CraterData>> delayGroups = new HashMap<Integer, List<CraterData>>();
        for (CraterData data : craterBlocks) {
            delayGroups.computeIfAbsent(data.getDelay(), k -> new ArrayList()).add(data);
        }
        BlastExplosionGenerator.spawnFlyingDebris(level, centerPos, radius);
        BlastExplosionGenerator.processDelayedDestruction(level, centerPos, delayGroups, debrisPositions, aboveGroundBlocks, radius, depth, 0);
    }

    private static void spawnFlyingDebris(ServerLevel level, BlockPos centerPos, int radius) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 200; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double dist = random.m_188500_() * (double)radius * 0.7;
            double x = (double)centerPos.m_123341_() + Math.cos(angle) * dist + 0.5;
            double y = (double)centerPos.m_123342_() + 0.5;
            double z = (double)centerPos.m_123343_() + Math.sin(angle) * dist + 0.5;
            double velocityX = (Math.cos(angle) + (random.m_188500_() - 0.5) * 0.5) * 2.5;
            double velocityY = 1.5 + random.m_188500_() * 2.0;
            double velocityZ = (Math.sin(angle) + (random.m_188500_() - 0.5) * 0.5) * 2.5;
            if (!(random.m_188501_() < 0.3f)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, velocityX * 0.5, velocityY * 0.5, velocityZ * 0.5, 0.1);
        }
    }

    private static void processDelayedDestruction(ServerLevel level, BlockPos centerPos, Map<Integer, List<CraterData>> delayGroups, Set<BlockPos> debrisPositions, Set<BlockPos> aboveGroundBlocks, int radius, int depth, int currentDelay) {
        int maxDelay = delayGroups.keySet().stream().max(Integer::compare).orElse(0);
        BlastExplosionGenerator.damageEntitiesInRadius(level, centerPos, radius + 10, currentDelay, maxDelay);
        List<CraterData> currentGroup = delayGroups.get(currentDelay);
        if (currentGroup != null) {
            for (CraterData data : currentGroup) {
                BlockPos pos = data.getPosition();
                BlastExplosionGenerator.createExplosionParticles(level, pos);
                BlockState state = level.m_8055_(pos);
                float hardness = state.m_60800_((BlockGetter)level, pos);
                float breakChance = BlastExplosionGenerator.calculateBreakChance(hardness);
                if (!(level.f_46441_.m_188501_() < breakChance)) continue;
                if (data.isCreateDebris()) {
                    BlastExplosionGenerator.createDebrisParticle(level, pos);
                }
                level.m_7471_(pos, false);
            }
        }
        if (currentDelay == 0) {
            for (BlockPos pos : aboveGroundBlocks) {
                BlockState state = level.m_8055_(pos);
                BlastExplosionGenerator.createExplosionParticles(level, pos);
                BlastExplosionGenerator.createDebrisParticle(level, pos);
                level.m_7471_(pos, false);
            }
            BlastExplosionGenerator.createScatteredDebris(level, debrisPositions);
        }
        if (currentDelay < maxDelay) {
            int nextDelay = currentDelay + 1;
            level.m_7654_().m_6937_((Runnable)new TickTask(2, () -> BlastExplosionGenerator.processDelayedDestruction(level, centerPos, delayGroups, debrisPositions, aboveGroundBlocks, radius, depth, nextDelay)));
        } else {
            BlastExplosionGenerator.generateCraterSurface(level, centerPos, BlastExplosionGenerator.extractPositions(delayGroups));
        }
    }

    private static void damageEntitiesInRadius(ServerLevel level, BlockPos centerPos, int radius, int currentDelay, int totalDelays) {
        AABB damageArea = new AABB(centerPos).m_82400_((double)radius);
        List entities = level.m_45933_((Entity)null, damageArea);
        Vec3 center = centerPos.m_252807_();
        for (Entity entity : entities) {
            float damage;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double distance = entity.m_20182_().m_82554_(center);
            if (!(distance <= (double)radius) || !((damage = BlastExplosionGenerator.calculateExplosionDamage(distance, radius, currentDelay, totalDelays)) > 0.5f)) continue;
            DamageSource explosionDamage = level.m_269111_().m_269036_(null, null);
            livingEntity.m_6469_(explosionDamage, damage);
            BlastExplosionGenerator.applyKnockback(livingEntity, centerPos, distance, radius);
        }
    }

    private static float calculateExplosionDamage(double distance, int radius, int currentDelay, int totalDelays) {
        float distanceFactor = Math.max(0.0f, 1.0f - (float)(distance / (double)radius));
        float timeFactor = Math.max(0.2f, 1.0f - (float)currentDelay / (float)totalDelays * 0.6f);
        return 25.0f * distanceFactor * distanceFactor * timeFactor;
    }

    private static void applyKnockback(LivingEntity entity, BlockPos centerPos, double distance, int radius) {
        if (distance > 0.1) {
            double knockbackStrength = Math.max(0.1, 1.0 - distance / (double)radius) * 3.0;
            Vec3 entityPos = entity.m_20182_();
            Vec3 center = centerPos.m_252807_();
            double deltaX = entityPos.f_82479_ - center.f_82479_;
            double deltaZ = entityPos.f_82481_ - center.f_82481_;
            double deltaY = 0.7;
            double length = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (length > 0.0) {
                deltaX /= length;
                deltaZ /= length;
            }
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * knockbackStrength, deltaY * knockbackStrength * 0.6, deltaZ * knockbackStrength));
        }
    }

    private static double[][] generatePerlinNoise(int width, int height, RandomSource random) {
        double[][] noise = new double[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = 0.0;
                double amplitude = 1.0;
                double frequency = 0.08;
                for (int octave = 0; octave < 5; ++octave) {
                    value += BlastExplosionGenerator.noise((double)x * frequency, (double)y * frequency, random) * amplitude;
                    amplitude *= 0.5;
                    frequency *= 2.0;
                }
                noise[x][y] = Math.max(0.0, Math.min(1.0, value * 0.5 + 0.5));
            }
        }
        return noise;
    }

    private static double noise(double x, double y, RandomSource random) {
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        random.m_188584_((long)ix * 374761393L + (long)iy * 668265263L);
        return random.m_188500_() * 2.0 - 1.0;
    }

    private static int calculateParabolicDepth(double distance, double radius, int maxDepth, double noise) {
        double normalizedDist = distance / radius;
        double depthFactor = 1.0 - normalizedDist * normalizedDist;
        depthFactor = Math.pow(depthFactor, 0.8);
        double noiseModifier = 1.0 + (noise - 0.5) * 0.3;
        return Math.max(1, (int)((double)maxDepth * depthFactor * noiseModifier));
    }

    private static double calculateRimHeight(double distance, double modifiedRadius, int radius, double noise) {
        double rimCenter = modifiedRadius;
        double rimWidth = (double)radius * 0.3;
        double distFromRim = Math.abs(distance - rimCenter);
        double heightFactor = Math.exp(-(distFromRim * distFromRim) / (2.0 * rimWidth * rimWidth));
        double baseHeight = (double)radius * 0.08;
        return (baseHeight * heightFactor + noise * 2.0) * (1.0 + noise * 0.5);
    }

    private static boolean shouldDestroyBlock(ServerLevel level, BlockPos pos, double distance, double radius, int y, int depth, RandomSource random) {
        BlockState state = level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)level, pos);
        float baseChance = BlastExplosionGenerator.calculateBreakChance(hardness);
        float distanceModifier = Math.max(0.4f, 1.0f - (float)(distance / radius));
        float depthModifier = Math.max(0.6f, 1.0f - (float)Math.abs(y) / (float)depth);
        return random.m_188501_() < baseChance * distanceModifier * depthModifier;
    }

    private static int calculateDestructionDelay(double distance, double radius) {
        return (int)(distance / radius * 25.0);
    }

    private static void createExplosionParticles(ServerLevel level, BlockPos pos) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2, 0.3, 0.3, 0.3, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.8, 0.8, 0.8, 0.03);
    }

    private static void createDebrisParticle(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 6, 0.4, 0.4, 0.4, 0.15);
    }

    private static void createScatteredDebris(ServerLevel level, Set<BlockPos> debrisPositions) {
        RandomSource random = level.f_46441_;
        for (BlockPos pos : debrisPositions) {
            if (!level.m_8055_(pos).m_60795_() && !level.m_8055_(pos).m_247087_()) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 2, 0.1, 0.1, 0.1, 0.02);
        }
    }

    private static BlockPos findSurfacePosition(ServerLevel level, BlockPos startPos) {
        for (int y = startPos.m_123342_() + 20; y >= startPos.m_123342_() - 10; --y) {
            BlockPos checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            BlockPos below = checkPos.m_7495_();
            if (level.m_8055_(checkPos).m_280296_() || !level.m_8055_(below).m_280296_()) continue;
            return checkPos;
        }
        return null;
    }

    private static List<BlockPos> extractPositions(Map<Integer, List<CraterData>> delayGroups) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (List<CraterData> group : delayGroups.values()) {
            for (CraterData data : group) {
                positions.add(data.getPosition());
            }
        }
        return positions;
    }

    private static float calculateBreakChance(float hardness) {
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (hardness <= 3.0f) {
            return 1.0f;
        }
        if (hardness >= 50.0f) {
            return 0.1f;
        }
        float range = 47.0f;
        return 1.0f - (hardness - 3.0f) / range;
    }

    private static void generateCraterSurface(ServerLevel level, BlockPos centerPos, List<BlockPos> craterBlocks) {
        RandomSource random = level.f_46441_;
        HashSet<BlockPos> craterBlocksSet = new HashSet<BlockPos>(craterBlocks);
        HashSet<BlockPos> bottomBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : craterBlocks) {
            BlockPos below = pos.m_7495_();
            if (craterBlocksSet.contains(below) || level.m_8055_(pos).m_60795_()) continue;
            bottomBlocks.add(pos);
        }
    }

    private static class CraterData {
        private final BlockPos position;
        private final int delay;
        private final boolean createDebris;

        public CraterData(BlockPos position, int delay, boolean createDebris) {
            this.position = position;
            this.delay = delay;
            this.createDebris = createDebris;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getDelay() {
            return this.delay;
        }

        public boolean isCreateDebris() {
            return this.createDebris;
        }
    }
}

