/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlastwaveGenerator {
    private static final int ZONE_3_RADIUS = 25;
    private static final int ZONE_4_RADIUS = 35;
    private static final int DAMAGE_ZONE_HEIGHT = 20;

    public static void generateCrater(ServerLevel level, BlockPos centerPos, int craterRadius, int craterDepth, Block wasteLogBlock, Block wastePlanksBlock) {
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        RandomSource random = level.f_46441_;
        for (int x = centerX - craterRadius; x <= centerX + craterRadius; ++x) {
            for (int y = centerY - craterRadius; y <= centerY + craterRadius; ++y) {
                for (int z = centerZ - craterRadius; z <= centerZ + craterRadius; ++z) {
                    BlockPos checkPos;
                    BlockState state;
                    double noise;
                    double norm;
                    double smoothDepth;
                    double dx = x - centerX;
                    double dy = y - centerY;
                    double dz = z - centerZ;
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (dist > (double)craterRadius || !(dist <= (smoothDepth = (double)craterDepth * Math.cos((norm = dist / (double)craterRadius) * Math.PI / 2.0)) + (noise = (random.m_188500_() - 0.5) * 2.0)) || (state = level.m_8055_(checkPos = new BlockPos(x, y, z))).m_60795_()) continue;
                    level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        BlastwaveGenerator.applyDamageZones(level, centerPos, wasteLogBlock, wastePlanksBlock);
    }

    private static void applyDamageZones(ServerLevel level, BlockPos centerPos, Block wasteLogBlock, Block wastePlanksBlock) {
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        int searchRadius = 35;
        int topSearchHeight = 60;
        int bottomSearchHeight = 20;
        RandomSource random = level.f_46441_;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                for (int y = centerY - bottomSearchHeight; y <= centerY + topSearchHeight; ++y) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    double dx = x - centerX;
                    double dz = z - centerZ;
                    double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
                    if (horizontalDistance > 35.0) continue;
                    BlockState state = level.m_8055_(checkPos);
                    if (horizontalDistance <= 25.0) {
                        if (!state.m_204336_(BlockTags.f_13035_)) continue;
                        level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                        continue;
                    }
                    if (!(horizontalDistance <= 35.0) || !state.m_204336_(BlockTags.f_13035_) || !(random.m_188501_() < 0.4f)) continue;
                    level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }
}

