/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BlockExplosionDefense {
    public static int getExplosionDefenseLevel(BlockState state, ServerLevel level, BlockPos pos) {
        float hardness = state.m_60800_((BlockGetter)level, pos);
        if (hardness < 0.0f) {
            return 15;
        }
        if (hardness < 1.0f) {
            return 0;
        }
        if (hardness < 2.0f) {
            return 1;
        }
        if (hardness < 3.0f) {
            return 2;
        }
        if (hardness < 5.0f) {
            return 3;
        }
        if (hardness < 10.0f) {
            return 5;
        }
        if (hardness < 15.0f) {
            return 8;
        }
        if (hardness < 30.0f) {
            return 10;
        }
        if (hardness < 50.0f) {
            return 14;
        }
        return 15;
    }

    public static ExplosionDefenseResult calculateExplosionDamage(ServerLevel level, BlockPos pos, BlockPos centerPos, float maxRadius, RandomSource random) {
        BlockState state = level.m_8055_(pos);
        int defenseLevel = BlockExplosionDefense.getExplosionDefenseLevel(state, level, pos);
        double dx = pos.m_123341_() - centerPos.m_123341_();
        double dz = pos.m_123343_() - centerPos.m_123343_();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        int ring = BlockExplosionDefense.calculateRingIndex(horizontalDistance, maxRadius, 6);
        return BlockExplosionDefense.applyExplosionDefense(defenseLevel, ring, random);
    }

    private static int calculateRingIndex(double distance, float maxRadius, int totalRings) {
        if (distance >= (double)maxRadius) {
            return totalRings - 1;
        }
        int ring = (int)(distance / (double)maxRadius * (double)totalRings);
        return Math.min(ring, totalRings - 1);
    }

    private static ExplosionDefenseResult applyExplosionDefense(int defenseLevel, int ring, RandomSource random) {
        if (defenseLevel == 15) {
            return new ExplosionDefenseResult(false, false);
        }
        if (defenseLevel == 0) {
            return new ExplosionDefenseResult(true, false);
        }
        if (ring <= 1) {
            if (defenseLevel >= 1 && defenseLevel <= 10) {
                return new ExplosionDefenseResult(true, false);
            }
            if (defenseLevel >= 11 && defenseLevel <= 14) {
                return new ExplosionDefenseResult(true, true);
            }
        }
        if (ring >= 2) {
            if (defenseLevel >= 1 && defenseLevel <= 5) {
                return new ExplosionDefenseResult(true, false);
            }
            if (defenseLevel >= 6 && defenseLevel <= 10) {
                float sellafitChance = BlockExplosionDefense.getSelafitChanceForDefenseLevel(defenseLevel);
                boolean becomesSellafit = random.m_188501_() < sellafitChance;
                return new ExplosionDefenseResult(becomesSellafit, becomesSellafit);
            }
            if (defenseLevel >= 11 && defenseLevel <= 14) {
                float sellafitChance = BlockExplosionDefense.getSelafitChanceForDefenseLevel(defenseLevel);
                boolean becomesSellafit = random.m_188501_() < sellafitChance;
                return new ExplosionDefenseResult(becomesSellafit, becomesSellafit);
            }
        }
        return new ExplosionDefenseResult(false, false);
    }

    private static float getSelafitChanceForDefenseLevel(int level) {
        return switch (level) {
            case 11 -> 0.3f;
            case 12 -> 0.15f;
            case 13 -> 0.05f;
            case 14 -> 0.01f;
            default -> 0.0f;
        };
    }

    public static ExplosionDefenseResult calculateExplosionDamageWithBaseProbability(ServerLevel level, BlockPos pos, BlockPos centerPos, float maxRadius, RandomSource random) {
        BlockState state = level.m_8055_(pos);
        int defenseLevel = BlockExplosionDefense.getExplosionDefenseLevel(state, level, pos);
        double dx = pos.m_123341_() - centerPos.m_123341_();
        double dz = pos.m_123343_() - centerPos.m_123343_();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        int ring = BlockExplosionDefense.calculateRingIndex(horizontalDistance, maxRadius, 6);
        if (defenseLevel == 0) {
            return new ExplosionDefenseResult(true, false);
        }
        if (defenseLevel == 15) {
            return new ExplosionDefenseResult(false, false);
        }
        if (defenseLevel >= 1 && defenseLevel <= 5) {
            float destroyChance = BlockExplosionDefense.getDestroyChanceForLevel1to5(defenseLevel);
            if (random.m_188501_() < destroyChance) {
                return new ExplosionDefenseResult(true, false);
            }
            return new ExplosionDefenseResult(true, true);
        }
        if (defenseLevel >= 6 && defenseLevel <= 10) {
            float selafitChance = BlockExplosionDefense.getSelafitChanceForLevel6to10(defenseLevel);
            if (random.m_188501_() < selafitChance) {
                return new ExplosionDefenseResult(true, true);
            }
            return new ExplosionDefenseResult(false, false);
        }
        if (defenseLevel >= 11 && defenseLevel <= 14) {
            float selafitChance = BlockExplosionDefense.getSelafitChanceForDefenseLevel(defenseLevel);
            if (random.m_188501_() < selafitChance) {
                return new ExplosionDefenseResult(true, true);
            }
            return new ExplosionDefenseResult(false, false);
        }
        return new ExplosionDefenseResult(false, false);
    }

    private static float getDestroyChanceForLevel1to5(int level) {
        return switch (level) {
            case 1 -> 0.9f;
            case 2 -> 0.85f;
            case 3 -> 0.8f;
            case 4 -> 0.75f;
            case 5 -> 0.7f;
            default -> 0.0f;
        };
    }

    private static float getSelafitChanceForLevel6to10(int level) {
        return switch (level) {
            case 6 -> 0.7f;
            case 7 -> 0.65f;
            case 8 -> 0.6f;
            case 9 -> 0.55f;
            case 10 -> 0.5f;
            default -> 0.0f;
        };
    }

    public static class ExplosionDefenseResult {
        public boolean shouldBreak;
        public boolean replaceWithSellafit;

        public ExplosionDefenseResult(boolean shouldBreak, boolean replaceWithSellafit) {
            this.shouldBreak = shouldBreak;
            this.replaceWithSellafit = replaceWithSellafit;
        }
    }
}

