/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.util.BlockExplosionDefense;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockExplosionDefenseExamples {
    public static void printAllVanillaBlocksWithDefenseLevel() {
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551           \u0422\u0410\u0411\u041b\u0418\u0426\u0410 \u0412\u0410\u041d\u0418\u041b\u042c\u041d\u042b\u0425 \u0411\u041b\u041e\u041a\u041e\u0412 \u0418 \u0418\u0425 \u0423\u0420\u041e\u0412\u041d\u0415\u0419 \u0417\u0410\u0429\u0418\u0422\u042b (0-15)                        \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println();
        Map<String, VanillaBlockInfo> blockMap = BlockExplosionDefenseExamples.getVanillaBlocksTable();
        blockMap.values().stream().sorted(Comparator.comparingInt(b -> b.defenseLevel)).forEach(block -> System.out.printf("\u251c\u2500 [\u0423\u0440\u043e\u0432\u0435\u043d\u044c %2d] %-40s (\u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c: %6.2f) - %s\n", block.defenseLevel, block.blockName, Float.valueOf(block.hardness), block.category));
        System.out.println();
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println();
    }

    public static void printVanillaBlocksByCategory() {
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551        \u0412\u0410\u041d\u0418\u041b\u042c\u041d\u042b\u0415 \u0411\u041b\u041e\u041a\u0418, \u0421\u0413\u0420\u0423\u041f\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u041d\u042b\u0415 \u041f\u041e \u041a\u0410\u0422\u0415\u0413\u041e\u0420\u0418\u042f\u041c \u0418 \u0423\u0420\u041e\u0412\u041d\u042e \u0417\u0410\u0429\u0418\u0422\u042b                \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println();
        Map<String, VanillaBlockInfo> blockMap = BlockExplosionDefenseExamples.getVanillaBlocksTable();
        TreeMap<String, List> byCategory = new TreeMap<String, List>();
        blockMap.values().forEach(block -> byCategory.computeIfAbsent(block.category, k -> new ArrayList()).add(block));
        byCategory.forEach((category, blocks) -> {
            System.out.println("\u250c\u2500 " + category.toUpperCase());
            System.out.println("\u2502");
            blocks.stream().sorted(Comparator.comparingInt(b -> b.defenseLevel)).forEach(block -> System.out.printf("\u2502  \u251c\u2500 [\u0423\u0440\u043e\u0432\u0435\u043d\u044c %2d] %-35s (\u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c: %6.2f)\n", block.defenseLevel, block.blockName, Float.valueOf(block.hardness)));
            System.out.println("\u2502");
        });
        System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println();
    }

    public static void printDefenseLevelStatistics() {
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551                    \u0421\u0422\u0410\u0422\u0418\u0421\u0422\u0418\u041a\u0410 \u041f\u041e \u0423\u0420\u041e\u0412\u041d\u042f\u041c \u0417\u0410\u0429\u0418\u0422\u042b                                       \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        System.out.println();
        Map<String, VanillaBlockInfo> blockMap = BlockExplosionDefenseExamples.getVanillaBlocksTable();
        TreeMap countByLevel = new TreeMap();
        blockMap.values().forEach(block -> countByLevel.merge(block.defenseLevel, 1, Integer::sum));
        System.out.println("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0437\u0430\u0449\u0438\u0442\u044b \u2502 \u041a\u043e\u043b-\u0432\u043e \u0431\u043b\u043e\u043a\u043e\u0432 \u2502 \u041f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u0432\u0437\u0440\u044b\u0432\u0435");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        for (int level = 0; level <= 15; ++level) {
            int count = countByLevel.getOrDefault(level, 0);
            String behavior = BlockExplosionDefenseExamples.getDefenseLevelBehavior(level);
            System.out.printf("      %2d        \u2502      %3d      \u2502 %s\n", level, count, behavior);
        }
        System.out.println();
        System.out.printf("\u0412\u0441\u0435\u0433\u043e \u0431\u043b\u043e\u043a\u043e\u0432: %d\n", blockMap.size());
        System.out.println();
    }

    private static Map<String, VanillaBlockInfo> getVanillaBlocksTable() {
        LinkedHashMap<String, VanillaBlockInfo> blocks = new LinkedHashMap<String, VanillaBlockInfo>();
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0430\u0432\u0430", Blocks.f_49991_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0412\u043e\u0434\u0430", Blocks.f_49990_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0422\u0440\u0430\u0432\u0430", Blocks.f_50034_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0412\u044b\u0441\u043e\u043a\u0430\u044f \u0442\u0440\u0430\u0432\u0430", Blocks.f_50359_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u043e\u0440\u0441\u043a\u0430\u044f \u0442\u0440\u0430\u0432\u0430", Blocks.f_50037_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0412\u044b\u0441\u043e\u043a\u0430\u044f \u043c\u043e\u0440\u0441\u043a\u0430\u044f \u0442\u0440\u0430\u0432\u0430", Blocks.f_50038_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0421\u043d\u0435\u0433", Blocks.f_50125_, 0.0f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0426\u0432\u0435\u0442\u043e\u043a \u043e\u0434\u0443\u0432\u0430\u043d\u0447\u0438\u043a", Blocks.f_50111_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0426\u0432\u0435\u0442\u043e\u043a \u043c\u0430\u043a", Blocks.f_50112_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043e\u043b\u0443\u0431\u0430\u044f \u043e\u0440\u0445\u0438\u0434\u0435\u044f", Blocks.f_50113_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0440\u0430\u0441\u043d\u044b\u0439 \u0442\u044e\u043b\u044c\u043f\u0430\u043d", Blocks.f_50116_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041e\u0440\u0430\u043d\u0436\u0435\u0432\u044b\u0439 \u0442\u044e\u043b\u044c\u043f\u0430\u043d", Blocks.f_50117_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0435\u043b\u044b\u0439 \u0442\u044e\u043b\u044c\u043f\u0430\u043d", Blocks.f_50118_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0420\u043e\u0437\u043e\u0432\u044b\u0439 \u0442\u044e\u043b\u044c\u043f\u0430\u043d", Blocks.f_50119_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0438\u043b\u0438\u044f \u043a\u0443\u0432\u0448\u0438\u043d\u043a\u0430", Blocks.f_50071_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u044e\u043f\u0438\u043d", Blocks.f_50113_, 0.0f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0417\u0435\u043c\u043b\u044f", Blocks.f_50493_, 0.5f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u0435\u0441\u043e\u043a", Blocks.f_49992_, 0.5f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0440\u0430\u0441\u043d\u044b\u0439 \u043f\u0435\u0441\u043e\u043a", Blocks.f_49993_, 0.5f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u0440\u0430\u0432\u0438\u0439", Blocks.f_49994_, 0.6f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0414\u0443\u0431\u043e\u0432\u044b\u0435 \u0434\u043e\u0441\u043a\u0438", Blocks.f_50705_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0415\u043b\u043e\u0432\u044b\u0435 \u0434\u043e\u0441\u043a\u0438", Blocks.f_50741_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0435\u0440\u0435\u0437\u043e\u0432\u044b\u0435 \u0434\u043e\u0441\u043a\u0438", Blocks.f_50742_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0414\u0443\u0431\u043e\u0432\u043e\u0435 \u0431\u0440\u0435\u0432\u043d\u043e", Blocks.f_49999_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0415\u043b\u043e\u0432\u043e\u0435 \u0431\u0440\u0435\u0432\u043d\u043e", Blocks.f_50000_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0435\u0440\u0435\u0437\u043e\u0432\u043e\u0435 \u0431\u0440\u0435\u0432\u043d\u043e", Blocks.f_50001_, 2.0f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0438\u0441\u0442\u0432\u0430 \u0434\u0443\u0431\u0430", Blocks.f_50050_, 0.2f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0438\u0441\u0442\u0432\u0430 \u0435\u043b\u0438", Blocks.f_50051_, 0.2f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0438\u0441\u0442\u0432\u0430 \u0431\u0435\u0440\u0435\u0437\u044b", Blocks.f_50052_, 0.2f, "\u0414\u0435\u0440\u0435\u0432\u043e");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0443\u043b\u044b\u0436\u043d\u0438\u043a", Blocks.f_50652_, 2.0f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u043e\u0445", Blocks.f_152544_, 0.1f, "\u0420\u0430\u0441\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0430\u043c\u0435\u043d\u044c", Blocks.f_50069_, 1.5f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u0440\u0430\u043d\u0438\u0442", Blocks.f_50122_, 1.5f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0414\u0438\u043e\u0440\u0438\u0442", Blocks.f_50228_, 1.5f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0410\u043d\u0434\u0435\u0437\u0438\u0442", Blocks.f_50334_, 1.5f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u0435\u0441\u0447\u0430\u043d\u0438\u043a", Blocks.f_50062_, 0.8f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0440\u0430\u0441\u043d\u044b\u0439 \u043f\u0435\u0441\u0447\u0430\u043d\u0438\u043a", Blocks.f_50394_, 0.8f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0418\u0437\u0432\u0435\u0441\u0442\u043d\u044f\u043a", Blocks.f_152497_, 0.75f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0430\u043c\u0435\u043d\u043d\u044b\u0439 \u043a\u0438\u0440\u043f\u0438\u0447", Blocks.f_50222_, 1.5f, "\u041a\u0438\u0440\u043f\u0438\u0447");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0443\u043b\u044b\u0436\u043d\u0438\u043a \u0441 \u0442\u0440\u0435\u0449\u0438\u043d\u0430\u043c\u0438", Blocks.f_50224_, 1.5f, "\u041a\u0438\u0440\u043f\u0438\u0447");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u043e\u0445 \u0431\u0443\u043b\u044b\u0436\u043d\u0438\u043a", Blocks.f_50079_, 2.0f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0438\u0440\u043f\u0438\u0447 \u041d\u0438\u0436\u043d\u0435\u0433\u043e \u043c\u0438\u0440\u0430", Blocks.f_50197_, 0.4f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446", Blocks.f_152550_, 3.0f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u0438\u0440\u043f\u0438\u0447 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430", Blocks.f_152589_, 3.0f, "\u041a\u0438\u0440\u043f\u0438\u0447");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041e\u0431\u043b\u0438\u0446\u043e\u0432\u043a\u0430 \u0438\u0437 \u0433\u043b\u0443\u0431\u0438\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0430\u043d\u0446\u0430", Blocks.f_152559_, 3.0f, "\u041a\u0438\u0440\u043f\u0438\u0447");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0430\u0437\u0430\u043b\u044c\u0442", Blocks.f_50137_, 1.25f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u043e\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0431\u0430\u0437\u0430\u043b\u044c\u0442", Blocks.f_50138_, 1.25f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0443\u0433\u043b\u044f", Blocks.f_50353_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0441\u044b\u0440\u043e\u0433\u043e \u0436\u0435\u043b\u0435\u0437\u0430", Blocks.f_152598_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0441\u044b\u0440\u043e\u0433\u043e \u043c\u0435\u0434\u0438", Blocks.f_152599_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0441\u044b\u0440\u043e\u0433\u043e \u0437\u043e\u043b\u043e\u0442\u0430", Blocks.f_152600_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0416\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_49996_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u0435\u0434\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_152505_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0417\u043e\u043b\u043e\u0442\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_49995_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0423\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_49997_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50075_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u0435\u0434\u043d\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_152504_, 3.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u043e\u043a\u0438\u0441\u043b\u0435\u043d\u043d\u043e\u0439 \u043c\u0435\u0434\u0438", Blocks.f_152501_, 3.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0417\u043e\u043b\u043e\u0442\u043e\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50074_, 3.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0438\u0437\u0443\u043c\u0440\u0443\u0434\u0430", Blocks.f_50268_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u043a\u0440\u0430\u0441\u043d\u043e\u0433\u043e \u043a\u0430\u043c\u043d\u044f", Blocks.f_50330_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0430\u0437\u0443\u043b\u0438\u0442\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50060_, 3.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0430\u043c\u0435\u0442\u0438\u0441\u0442\u0430", Blocks.f_152490_, 1.5f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0418\u0437\u0443\u043c\u0440\u0443\u0434\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_50264_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0420\u0443\u0434\u0430 \u043a\u0440\u0430\u0441\u043d\u043e\u0433\u043e \u043a\u0430\u043c\u043d\u044f", Blocks.f_50173_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041b\u0430\u0437\u0443\u043b\u0438\u0442\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_50059_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0420\u0443\u0434\u0430 \u0434\u0440\u0435\u0432\u043d\u0435\u0433\u043e \u043e\u0431\u043b\u043e\u043c\u043a\u0430", Blocks.f_50722_, 30.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446 \u0436\u0435\u043b\u0435\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_152468_, 4.5f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446 \u043c\u0435\u0434\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_152506_, 4.5f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446 \u0437\u043e\u043b\u043e\u0442\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_152467_, 4.5f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0413\u043b\u0443\u0431\u0438\u043d\u043d\u044b\u0439 \u0441\u043b\u0430\u043d\u0435\u0446 \u0430\u043b\u043c\u0430\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_152474_, 4.5f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0410\u043b\u043c\u0430\u0437\u043d\u0430\u044f \u0440\u0443\u0434\u0430", Blocks.f_50089_, 3.0f, "\u0420\u0443\u0434\u044b");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0410\u043b\u043c\u0430\u0437\u043d\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50090_, 5.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d", Blocks.f_50080_, 50.0f, "\u041a\u0430\u043c\u0435\u043d\u044c");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u043b\u0430\u0447 \u043e\u0431\u0441\u0438\u0434\u0438\u0430\u043d\u0430", Blocks.f_50723_, 50.0f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u0443\u0440\u043f\u0443\u0440", Blocks.f_50492_, 1.5f, "\u041a\u0440\u0430\u0439");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u043e\u043d\u0435\u0446 \u0441\u0442\u0435\u0440\u0436\u043d\u044f", Blocks.f_50489_, 0.0f, "\u041a\u0440\u0430\u0439");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u043d\u0435\u0437\u0435\u0440\u0438\u0442\u0430", Blocks.f_50721_, 250.0f, "\u0411\u043b\u043e\u043a\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0414\u0443\u0448\u0435\u0432\u043e\u0439 \u043f\u0435\u0441\u043e\u043a", Blocks.f_50135_, 0.5f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041c\u0430\u0433\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50450_, 0.5f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u043a\u0430\u043c\u043d\u044f", Blocks.f_50730_, 1.5f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u043e\u0437\u043e\u043b\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u0431\u043b\u043e\u043a\u0441", Blocks.f_50706_, 1.5f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u0443\u0440\u043f\u0443\u0440\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50441_, 1.5f, "\u041a\u0440\u0430\u0439");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u043e\u0440\u0435\u043d\u043d\u0430\u044f \u043f\u043e\u0440\u043e\u0434\u0430", Blocks.f_50752_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u043f\u043e\u0440\u043e\u0434\u0430", Blocks.f_50258_, -1.0f, "\u041a\u0440\u0430\u0439");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0420\u0430\u043c\u043a\u0430 \u043f\u043e\u0440\u0442\u0430\u043b\u0430 \u041d\u0438\u0436\u043d\u0435\u0433\u043e \u043c\u0438\u0440\u0430", Blocks.f_50142_, -1.0f, "\u041d\u0438\u0436\u043d\u0438\u0439 \u043c\u0438\u0440");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u042f\u0439\u0446\u043e \u0434\u0440\u0430\u043a\u043e\u043d\u0430", Blocks.f_50260_, -1.0f, "\u041a\u0440\u0430\u0439");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041a\u043e\u043c\u0430\u043d\u0434\u043d\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50272_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0426\u0435\u043f\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u043d\u044b\u0445 \u0431\u043b\u043e\u043a\u043e\u0432", Blocks.f_50448_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u043d\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_50447_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u043b\u043e\u043a \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b", Blocks.f_50677_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0421\u0438\u043d\u0438\u0439 \u043b\u0435\u0434", Blocks.f_50568_, 2.8f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0423\u043f\u0430\u043a\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043b\u0435\u0434", Blocks.f_50354_, 0.5f, "\u041f\u0440\u0438\u0440\u043e\u0434\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0411\u0430\u0440\u044c\u0435\u0440", Blocks.f_50375_, -1.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        BlockExplosionDefenseExamples.addBlock(blocks, "\u0421\u0432\u0435\u0442\u043b\u044b\u0439 \u0431\u043b\u043e\u043a", Blocks.f_152480_, 0.0f, "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435");
        return blocks;
    }

    private static void addBlock(Map<String, VanillaBlockInfo> map, String name, Block block, float hardness, String category) {
        BlockState state = block.m_49966_();
        int defenseLevel = BlockExplosionDefenseExamples.calculateDefenseLevel(hardness);
        map.put(name, new VanillaBlockInfo(name, hardness, defenseLevel, category));
    }

    private static int calculateDefenseLevel(float hardness) {
        if (hardness < 0.0f) {
            return 15;
        }
        if (hardness < 0.5f) {
            return 0;
        }
        if (hardness < 1.0f) {
            return 1;
        }
        if (hardness < 1.5f) {
            return 2;
        }
        if (hardness < 3.0f) {
            return 3;
        }
        if (hardness < 5.0f) {
            return 4;
        }
        if (hardness < 8.0f) {
            return 5;
        }
        if (hardness < 10.0f) {
            return 6;
        }
        if (hardness < 15.0f) {
            return 7;
        }
        if (hardness < 20.0f) {
            return 8;
        }
        if (hardness < 30.0f) {
            return 9;
        }
        if (hardness < 50.0f) {
            return 10;
        }
        if (hardness < 100.0f) {
            return 12;
        }
        if (hardness < 250.0f) {
            return 13;
        }
        if (hardness < 1000.0f) {
            return 14;
        }
        return 15;
    }

    private static String getDefenseLevelBehavior(int level) {
        return switch (level) {
            case 0 -> "\u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100% (\u0432\u0441\u0435\u0433\u0434\u0430 \u0432\u044b\u043f\u0430\u0434\u0430\u0435\u0442)";
            case 1, 2, 3, 4, 5, 6, 7 -> "\u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100% (\u0431\u043b\u0438\u0437\u043a\u043e) / \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442/\u043d\u0438\u0447\u0435\u0433\u043e (\u0434\u0430\u043b\u0435\u043a\u043e)";
            case 8, 9, 10 -> "\u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 100% (\u0434\u0430\u043b\u0435\u043a\u043e) / \u0420\u0435\u0434\u043a\u043e \u0440\u0430\u0437\u0440\u0443\u0448\u0430\u0435\u0442\u0441\u044f (\u0431\u043b\u0438\u0437\u043a\u043e)";
            case 11 -> "\u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 30%, \u041d\u0438\u0447\u0435\u0433\u043e 70% (\u0434\u0430\u043b\u0435\u043a\u043e)";
            case 12 -> "\u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 15%, \u041d\u0438\u0447\u0435\u0433\u043e 85% (\u0434\u0430\u043b\u0435\u043a\u043e)";
            case 13 -> "\u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 5%, \u041d\u0438\u0447\u0435\u0433\u043e 95% (\u0434\u0430\u043b\u0435\u043a\u043e)";
            case 14 -> "\u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 1%, \u041d\u0438\u0447\u0435\u0433\u043e 99% (\u0434\u0430\u043b\u0435\u043a\u043e)";
            case 15 -> "\u041d\u0438\u0447\u0435\u0433\u043e (\u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u043e)";
            default -> "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
        };
    }

    public static void exampleCheckDefenseLevel(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        int defenseLevel = BlockExplosionDefense.getExplosionDefenseLevel(state, level, pos);
        System.out.println("\u0411\u043b\u043e\u043a " + state.m_60734_().m_49954_().getString() + " \u0438\u043c\u0435\u0435\u0442 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0437\u0430\u0449\u0438\u0442\u044b: " + defenseLevel);
    }

    public static void exampleCheckBlockDamage(ServerLevel level, BlockPos blockPos, BlockPos centerPos, float radius) {
        RandomSource random = level.f_46441_;
        BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamage(level, blockPos, centerPos, radius, random);
        if (result.shouldBreak) {
            if (result.replaceWithSellafit) {
                System.out.println("\u0411\u043b\u043e\u043a \u0431\u0443\u0434\u0435\u0442 \u0417\u0410\u041c\u0415\u041d\u0415\u041d \u043d\u0430 \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442");
            } else {
                System.out.println("\u0411\u043b\u043e\u043a \u0431\u0443\u0434\u0435\u0442 \u0423\u0414\u0410\u041b\u0415\u041d");
            }
        } else {
            System.out.println("\u0411\u043b\u043e\u043a \u043e\u0441\u0442\u0430\u043d\u0435\u0442\u0441\u044f \u041d\u0415\u0422\u0420\u041e\u041d\u0423\u0422\u042b\u041c");
        }
    }

    public static void exampleCheckMultipleBlocks(ServerLevel level, BlockPos centerPos, int radius) {
        int checkRadius = radius + 50;
        RandomSource random = level.f_46441_;
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int z = -checkRadius; z <= checkRadius; ++z) {
                BlockPos checkPos = centerPos.m_7918_(x, 0, z);
                BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamage(level, checkPos, centerPos, radius, random);
                if (!result.shouldBreak) continue;
                System.out.println("\u0411\u043b\u043e\u043a \u043d\u0430 " + String.valueOf(checkPos) + " \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d");
            }
        }
    }

    public static void exampleBaseProbabilitySystem(ServerLevel level, BlockPos blockPos, BlockPos centerPos, float radius) {
        RandomSource random = level.f_46441_;
        BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamageWithBaseProbability(level, blockPos, centerPos, radius, random);
        if (result.shouldBreak) {
            if (result.replaceWithSellafit) {
                System.out.println("\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430: \u0431\u043b\u043e\u043a \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442\u043e\u043c");
            } else {
                System.out.println("\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430: \u0431\u043b\u043e\u043a \u0443\u0434\u0430\u043b\u044f\u0435\u0442\u0441\u044f");
            }
        }
    }

    public static void exampleTestDefenseLevels(ServerLevel level, BlockPos testPos) {
        BlockState[] testBlocks = new BlockState[]{Blocks.f_50090_.m_49966_(), Blocks.f_50080_.m_49966_(), Blocks.f_50752_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_49999_.m_49966_()};
        System.out.println("=== \u0422\u0415\u0421\u0422 \u0423\u0420\u041e\u0412\u041d\u0415\u0419 \u0417\u0410\u0429\u0418\u0422\u042b ===");
        for (BlockState block : testBlocks) {
            int defenseLevel = BlockExplosionDefense.getExplosionDefenseLevel(block, level, testPos);
            System.out.println(block.m_60734_().m_49954_().getString() + ": \u0443\u0440\u043e\u0432\u0435\u043d\u044c " + defenseLevel);
        }
    }

    public static void exampleSimulateExplosion(ServerLevel level, BlockPos centerPos, int radius) {
        RandomSource random = level.f_46441_;
        float maxRadius = (float)radius * 1.5f;
        int destroyedCount = 0;
        int selafitCount = 0;
        int survivedCount = 0;
        System.out.println("=== \u0418\u041c\u0418\u0422\u0410\u0426\u0418\u042f \u0412\u0417\u0420\u042b\u0412\u0410 ===");
        System.out.println("\u0426\u0435\u043d\u0442\u0440: " + String.valueOf(centerPos) + ", \u0420\u0430\u0434\u0438\u0443\u0441: " + radius);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double distance = Math.sqrt(x * x + z * z + y * y);
                    if (distance > (double)maxRadius) continue;
                    BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamage(level, checkPos, centerPos, maxRadius, random);
                    if (result.shouldBreak) {
                        if (result.replaceWithSellafit) {
                            ++selafitCount;
                            continue;
                        }
                        ++destroyedCount;
                        continue;
                    }
                    ++survivedCount;
                }
            }
        }
        System.out.println("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b:");
        System.out.println("  \u0423\u0434\u0430\u043b\u0435\u043d\u043e: " + destroyedCount);
        System.out.println("  \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442: " + selafitCount);
        System.out.println("  \u0412\u044b\u0436\u0438\u043b\u043e: " + survivedCount);
    }

    public static void exampleAnalyzeByRings(ServerLevel level, BlockState testBlockState, BlockPos centerPos, float maxRadius) {
        RandomSource random = level.f_46441_;
        int ringCount = 6;
        System.out.println("=== \u0410\u041d\u0410\u041b\u0418\u0417 \u041f\u041e \u041a\u041e\u041b\u042c\u0426\u0410\u041c ===");
        System.out.println("\u0411\u043b\u043e\u043a: " + testBlockState.m_60734_().m_49954_().getString());
        int defenseLevel = BlockExplosionDefense.getExplosionDefenseLevel(testBlockState, level, centerPos);
        System.out.println("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0437\u0430\u0449\u0438\u0442\u044b: " + defenseLevel);
        System.out.println();
        for (int ring = 0; ring < ringCount; ++ring) {
            double distance = (double)(maxRadius / (float)ringCount) * ((double)ring + 0.5);
            int testX = (int)distance;
            BlockPos testPos = centerPos.m_7918_(testX, 0, 0);
            int destroyCount = 0;
            int selafitCount = 0;
            for (int i = 0; i < 100; ++i) {
                BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamage(level, testPos, centerPos, maxRadius, random);
                if (!result.shouldBreak) continue;
                if (result.replaceWithSellafit) {
                    ++selafitCount;
                    continue;
                }
                ++destroyCount;
            }
            System.out.printf("\u041a\u043e\u043b\u044c\u0446\u043e %d (\u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 ~%.0f): \u0423\u0434\u0430\u043b\u0435\u043d\u043e %d%%, \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 %d%%\n", ring, distance, destroyCount, selafitCount);
        }
    }

    public static void examplePrintDefenseLevelTable() {
        System.out.println("=== \u0422\u0410\u0411\u041b\u0418\u0426\u0410 \u0423\u0420\u041e\u0412\u041d\u0415\u0419 \u0417\u0410\u0429\u0418\u0422\u042b ===");
        System.out.println();
        System.out.println("\u041a\u041e\u041b\u042c\u0426\u0410 0-3 (\u0431\u043b\u0438\u0437\u043a\u043e \u043a \u0446\u0435\u043d\u0442\u0440\u0443, 0-66%):");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 0:      \u2192 \u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 1-10:   \u2192 \u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 11-14:  \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 15:     \u2192 \u041d\u0438\u0447\u0435\u0433\u043e (\u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u043e)");
        System.out.println();
        System.out.println("\u041a\u041e\u041b\u042c\u0426\u0410 4-5 (\u0434\u0430\u043b\u0435\u043a\u043e \u043e\u0442 \u0446\u0435\u043d\u0442\u0440\u0430, 66-100%):");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 0:      \u2192 \u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 1-5:    \u2192 \u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 6-10:   \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 100%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 11:     \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 30%, \u041d\u0438\u0447\u0435\u0433\u043e 70%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 12:     \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 15%, \u041d\u0438\u0447\u0435\u0433\u043e 85%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 13:     \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 5%, \u041d\u0438\u0447\u0435\u0433\u043e 95%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 14:     \u2192 \u0421\u0435\u043b\u043b\u0430\u0444\u0438\u0442 1%, \u041d\u0438\u0447\u0435\u0433\u043e 99%");
        System.out.println("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c 15:     \u2192 \u041d\u0438\u0447\u0435\u0433\u043e (\u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u043e)");
    }

    public static void exampleCustomBlockDefenseLevel() {
        System.out.println("=== \u041e\u041f\u0420\u0415\u0414\u0415\u041b\u0415\u041d\u0418\u0415 \u0423\u0420\u041e\u0412\u041d\u042f \u0417\u0410\u0429\u0418\u0422\u042b ===");
        System.out.println();
        System.out.println("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u0438 \u2192 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0437\u0430\u0449\u0438\u0442\u044b:");
        System.out.println("  hardness < 0.5: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 0 (\u041c\u044f\u0433\u043a\u0438\u0435 \u0431\u043b\u043e\u043a\u0438)");
        System.out.println("  hardness < 1.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 1 (\u041e\u0447\u0435\u043d\u044c \u043c\u044f\u0433\u043a\u0438\u0435)");
        System.out.println("  hardness < 1.5: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 2 (\u041c\u044f\u0433\u043a\u0438\u0439 \u043a\u0430\u043c\u0435\u043d\u044c)");
        System.out.println("  hardness < 3.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 3 (\u0421\u043b\u0430\u0431\u044b\u0439 \u043a\u0430\u043c\u0435\u043d\u044c)");
        System.out.println("  hardness < 5.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 4 (\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043a\u0430\u043c\u0435\u043d\u044c)");
        System.out.println("  hardness < 8.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 5 (\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b)");
        System.out.println("  hardness < 10.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 6 (\u0422\u044f\u0436\u0435\u043b\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b)");
        System.out.println("  hardness < 15.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 7 (\u041e\u0447\u0435\u043d\u044c \u0442\u044f\u0436\u0435\u043b\u044b\u0439)");
        System.out.println("  hardness < 20.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 8 (\u041e\u0447\u0435\u043d\u044c \u0442\u044f\u0436\u0435\u043b\u044b\u0439+)");
        System.out.println("  hardness < 30.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 9 (\u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u043e \u0442\u044f\u0436\u0435\u043b\u044b\u0439)");
        System.out.println("  hardness < 50.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 10 (\u0421\u0443\u043f\u0435\u0440 \u0442\u044f\u0436\u0435\u043b\u044b\u0439)");
        System.out.println("  hardness < 100.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 12 (\u041f\u0440\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u044b\u0439)");
        System.out.println("  hardness < 250.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 13 (\u041f\u043e\u0447\u0442\u0438 \u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u044b\u0439)");
        System.out.println("  hardness < 1000.0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 14 (\u041a\u0440\u0430\u0439\u043d\u0435 \u0440\u0435\u0434\u043a\u043e \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u044b\u0439)");
        System.out.println("  hardness < 0: \u2192 \u0423\u0440\u043e\u0432\u0435\u043d\u044c 15 (Bedrock, \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043d\u0435\u0440\u0430\u0437\u0440\u0443\u0448\u0438\u043c\u044b\u0439)");
        System.out.println();
        System.out.println("\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u044d\u0442\u043e \u0432 BlockExplosionDefense");
        System.out.println("\u0434\u043b\u044f \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432 \u0432\u0430\u0448\u0435\u0433\u043e \u043c\u043e\u0434\u0430!");
    }

    public static void exampleIntegrationWithSellafit(ServerLevel level, BlockPos blockPos, BlockPos centerPos, float radius) {
        RandomSource random = level.f_46441_;
        BlockExplosionDefense.ExplosionDefenseResult result = BlockExplosionDefense.calculateExplosionDamage(level, blockPos, centerPos, radius, random);
        if (result.shouldBreak) {
            if (result.replaceWithSellafit) {
                System.out.println("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0435\u043b\u043b\u0430\u0444\u0438\u0442 \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: " + String.valueOf(blockPos));
            } else {
                level.m_7471_(blockPos, false);
                System.out.println("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u043b\u043e\u043a \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: " + String.valueOf(blockPos));
            }
        }
    }

    private static class VanillaBlockInfo {
        String blockName;
        float hardness;
        int defenseLevel;
        String category;

        VanillaBlockInfo(String blockName, float hardness, int defenseLevel, String category) {
            this.blockName = blockName;
            this.hardness = hardness;
            this.defenseLevel = defenseLevel;
            this.category = category;
        }
    }
}

