/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.world.biome.CraterBiomes;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;

public class CraterBiomeApplier {
    private static final int INNER_CRATER_RADIUS = 170;
    private static final int OUTER_CRATER_RADIUS = 280;

    public static void applyCraterBiomes(ServerLevel level, BlockPos centerPos, int radius) {
        long startTime = System.currentTimeMillis();
        System.out.println("[CRATER_BIOME] ========================================");
        System.out.println("[CRATER_BIOME] START: Applying crater biomes (v4)");
        System.out.println("[CRATER_BIOME] Bomb center: " + String.valueOf(centerPos));
        System.out.println("[CRATER_BIOME] Inner Crater: 0-170 blocks");
        System.out.println("[CRATER_BIOME] Outer Crater: 170-280 blocks");
        System.out.println("[CRATER_BIOME] ========================================");
        try {
            System.out.println("[CRATER_BIOME] Looking for biomes in registry...");
            Holder<Biome> innerCrater = CraterBiomeApplier.getBiomeHolder(level, CraterBiomes.INNER_CRATER_KEY);
            Holder<Biome> outerCrater = CraterBiomeApplier.getBiomeHolder(level, CraterBiomes.OUTER_CRATER_KEY);
            if (innerCrater == null || outerCrater == null) {
                System.err.println("[CRATER_BIOME] ERROR: Biomes not found!");
                return;
            }
            System.out.println("[CRATER_BIOME] \u2705 Biomes found, applying...");
            int appliedRadius = 312;
            int minChunkX = centerPos.m_123341_() - appliedRadius >> 4;
            int maxChunkX = centerPos.m_123341_() + appliedRadius >> 4;
            int minChunkZ = centerPos.m_123343_() - appliedRadius >> 4;
            int maxChunkZ = centerPos.m_123343_() + appliedRadius >> 4;
            int totalChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
            System.out.println("[CRATER_BIOME] Processing " + totalChunks + " chunks");
            int successfulChunks = 0;
            int failedChunks = 0;
            int totalBiomes = 0;
            int innerBiomes = 0;
            int outerBiomes = 0;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    try {
                        LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
                        if (chunk == null) {
                            ++failedChunks;
                            continue;
                        }
                        int[] stats = CraterBiomeApplier.applyBiomesToChunk((ChunkAccess)chunk, centerPos, innerCrater, outerCrater);
                        totalBiomes += stats[0];
                        innerBiomes += stats[1];
                        outerBiomes += stats[2];
                        chunk.m_8092_(true);
                        ++successfulChunks;
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("[CRATER_BIOME] ERROR: Chunk [" + chunkX + ", " + chunkZ + "]: " + e.getMessage());
                        ++failedChunks;
                    }
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.println("[CRATER_BIOME] ========================================");
            System.out.println("[CRATER_BIOME] \u2705 COMPLETE!");
            System.out.println("[CRATER_BIOME] Chunks processed: " + successfulChunks + " / " + totalChunks);
            System.out.println("[CRATER_BIOME] Chunks failed: " + failedChunks);
            System.out.println("[CRATER_BIOME] Inner Crater biomes applied: " + innerBiomes);
            System.out.println("[CRATER_BIOME] Outer Crater biomes applied: " + outerBiomes);
            System.out.println("[CRATER_BIOME] Total quarters modified: " + totalBiomes);
            System.out.println("[CRATER_BIOME] Time: " + (endTime - startTime) + " ms");
            System.out.println("[CRATER_BIOME] ========================================");
        }
        catch (Exception e) {
            System.err.println("[CRATER_BIOME] CRITICAL ERROR:");
            e.printStackTrace();
        }
    }

    private static Holder<Biome> getBiomeHolder(ServerLevel level, ResourceKey<Biome> key) {
        try {
            return level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(key);
        }
        catch (Exception e) {
            System.err.println("[CRATER_BIOME] ERROR: Cannot find biome " + String.valueOf(key.m_135782_()));
            return null;
        }
    }

    private static int[] applyBiomesToChunk(ChunkAccess chunk, BlockPos centerPos, Holder<Biome> innerCrater, Holder<Biome> outerCrater) {
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        int chunkBlockX = chunkX << 4;
        int chunkBlockZ = chunkZ << 4;
        LevelChunkSection[] sections = chunk.m_7103_();
        if (sections == null) {
            return new int[]{0, 0, 0};
        }
        int totalApplied = 0;
        int innerCount = 0;
        int outerCount = 0;
        boolean chunkChanged = false;
        for (LevelChunkSection section : sections) {
            PalettedContainerRO biomesRO;
            if (section == null || (biomesRO = section.m_187996_()) == null) continue;
            PalettedContainer biomes = biomesRO.m_238334_();
            boolean sectionChanged = false;
            for (int qx = 0; qx < 4; ++qx) {
                for (int qy = 0; qy < 4; ++qy) {
                    for (int qz = 0; qz < 4; ++qz) {
                        int blockX = chunkBlockX + (qx << 2) + 2;
                        int blockZ = chunkBlockZ + (qz << 2) + 2;
                        double dx = blockX - centerX;
                        double dz = blockZ - centerZ;
                        double distance = Math.sqrt(dx * dx + dz * dz);
                        Holder<Biome> biomeToSet = null;
                        if (distance <= 170.0) {
                            biomeToSet = innerCrater;
                            ++innerCount;
                        } else if (distance <= 280.0) {
                            biomeToSet = outerCrater;
                            ++outerCount;
                        }
                        if (biomeToSet == null) continue;
                        biomes.m_156470_(qx, qy, qz, biomeToSet);
                        sectionChanged = true;
                        ++totalApplied;
                    }
                }
            }
            if (!sectionChanged) continue;
            chunkChanged = true;
            CraterBiomeApplier.saveBiomesToSection(section, (PalettedContainer<Holder<Biome>>)biomes);
        }
        if (chunkChanged) {
            chunk.m_8092_(true);
        }
        return new int[]{totalApplied, innerCount, outerCount};
    }

    private static void saveBiomesToSection(LevelChunkSection section, PalettedContainer<Holder<Biome>> biomes) {
        try {
            try {
                Field field = LevelChunkSection.class.getDeclaredField("biomes");
                field.setAccessible(true);
                field.set(section, biomes);
                return;
            }
            catch (NoSuchFieldException field) {
                for (Field field2 : LevelChunkSection.class.getDeclaredFields()) {
                    String typeName = field2.getType().getTypeName();
                    if (!typeName.contains("PaletteContainer") || !typeName.contains("Biome")) continue;
                    field2.setAccessible(true);
                    field2.set(section, biomes);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[CRATER_BIOME] ERROR: Could not save biomes to section");
        }
    }
}

