/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.util.BlockExplosionDefense;
import com.hbm_m.util.CraterBiomeApplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DudCraterGenerator {
    private static final float STRETCH_FACTOR = 1.5f;
    private static final int REMOVAL_HEIGHT_ABOVE = 80;
    private static final float TOP_REMOVAL_RADIUS_MULTIPLIER = 1.3f;
    private static final int RING_COUNT = 8;
    private static final int SELLAFIT_REPLACEMENT_LAYERS = 4;
    private static final int CRATER_DEPTH = 30;
    private static final int ZONE_3_RADIUS = 85;
    private static final int ZONE_4_RADIUS = 140;
    private static final long ZONE_3_RADIUS_SQ = 7225L;
    private static final long ZONE_4_RADIUS_SQ = 19600L;
    private static final int DAMAGE_ZONE_HEIGHT = 80;
    private static final float ZONE_3_DAMAGE = 500.0f;
    private static final float ZONE_4_DAMAGE = 200.0f;
    private static final float FIRE_DURATION = 380.0f;
    private static final float HORIZONTAL_STRETCH_FACTOR = 0.0f;
    private static final float VERTICAL_STRETCH_FACTOR = 0.0f;
    private static final float RING_OVERLAP_PERCENTAGE = 20.0f;
    private static final int BLOCK_BATCH_SIZE = 256;
    private static final int SELLAFIT_OVERHANG_CHECK_DEPTH = 5;

    public static void generateCrater(ServerLevel level, BlockPos centerPos, int radius, int depth, Block sellafit1, Block sellafit2, Block sellafit3, Block sellafit4, Block wasteLogBlock, Block wastePlanksBlock, Block burnedGrassBlock) {
        RandomSource random = level.f_46441_;
        float stretchX = 1.0f + (random.m_188501_() - 0.5f) * 0.0f;
        float stretchZ = 1.0f + (random.m_188501_() - 0.5f) * 0.0f;
        float stretchY = 1.0f + (random.m_188501_() - 0.5f) * 0.0f;
        float horizontalRadius = (float)radius * 1.5f;
        float topRemovalRadius = horizontalRadius * 1.3f;
        Block[] selafitBlocks = new Block[]{sellafit1, sellafit2, sellafit3, sellafit4};
        ArrayList<Set<BlockPos>> rings = new ArrayList<Set<BlockPos>>();
        HashSet<BlockPos> craterBlocksSet = new HashSet<BlockPos>();
        for (int i = 0; i < 8; ++i) {
            rings.add(new HashSet());
        }
        long startTime = System.currentTimeMillis();
        DudCraterGenerator.collectCraterBlocksOptimized(level, centerPos, (int)topRemovalRadius, depth, horizontalRadius, topRemovalRadius, stretchX, stretchZ, stretchY, craterBlocksSet, rings);
        DudCraterGenerator.processAllRingsBatched(level, centerPos, rings, craterBlocksSet, selafitBlocks, random, topRemovalRadius, depth, wasteLogBlock, wastePlanksBlock, burnedGrassBlock);
        DudCraterGenerator.removeItemsInRadiusBatched(level, centerPos, (int)topRemovalRadius + 20);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6937_((Runnable)new TickTask(2, () -> {
                try {
                    CraterBiomeApplier.applyCraterBiomes(level, centerPos, (int)horizontalRadius);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                server.m_6937_((Runnable)new TickTask(1, () -> {
                    try {
                        DudCraterGenerator.applyDamageZonesOptimizedV2(level, centerPos, wasteLogBlock, wastePlanksBlock, burnedGrassBlock, selafitBlocks, random);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }));
            }));
        }
        long endTime = System.currentTimeMillis();
        System.out.println("[CRATER] \u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043a\u0440\u0430\u0442\u0435\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 " + (endTime - startTime) + " \u043c\u0441");
    }

    private static void collectCraterBlocksOptimized(ServerLevel level, BlockPos centerPos, int searchRadius, int depth, float horizontalRadius, float topRemovalRadius, float stretchX, float stretchZ, float stretchY, Set<BlockPos> craterBlocksSet, List<Set<BlockPos>> rings) {
        double invHorizontalRadiusX = 1.0 / (double)(horizontalRadius * stretchX);
        double invHorizontalRadiusZ = 1.0 / (double)(horizontalRadius * stretchZ);
        double invDepth = 1.0 / (double)((float)depth * stretchY);
        double topRemovalRadiusNorm = topRemovalRadius / horizontalRadius;
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        for (int y = -depth; y <= 80; ++y) {
            double normalizedY = Math.abs((double)y) * invDepth;
            if (normalizedY > 1.5) continue;
            double spheroidalFactor = Math.sqrt(Math.max(0.0, 1.0 - normalizedY * normalizedY));
            double edgeRadius = topRemovalRadiusNorm * spheroidalFactor;
            for (int x = -searchRadius; x <= searchRadius; ++x) {
                double normalizedX = (double)x * invHorizontalRadiusX;
                double normalizedXSq = normalizedX * normalizedX;
                if (normalizedXSq > 1.1) continue;
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    double normalizedZ = (double)z * invHorizontalRadiusZ;
                    double horizontalDistanceSq = normalizedXSq + normalizedZ * normalizedZ;
                    if (horizontalDistanceSq > 1.1) continue;
                    double horizontalDistance = Math.sqrt(horizontalDistanceSq);
                    boolean shouldCheck = false;
                    if (y <= 0) {
                        double ellipsoidDistance = Math.sqrt(horizontalDistanceSq + normalizedY * normalizedY);
                        shouldCheck = ellipsoidDistance <= 1.0;
                    } else if (y < 80 && horizontalDistance <= edgeRadius) {
                        shouldCheck = true;
                    }
                    if (!shouldCheck) continue;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockExplosionDefense.ExplosionDefenseResult defenseResult = BlockExplosionDefense.calculateExplosionDamage(level, checkPos, centerPos, horizontalRadius, level.f_46441_);
                    if (!defenseResult.shouldBreak) continue;
                    craterBlocksSet.add(checkPos);
                    DudCraterGenerator.distributeBlockToRingsWithOverlap(centerPos, checkPos, horizontalRadius, rings);
                }
            }
        }
    }

    private static void distributeBlockToRingsWithOverlap(BlockPos center, BlockPos pos, float maxRadius, List<Set<BlockPos>> rings) {
        double distance = Math.sqrt(Math.pow(pos.m_123341_() - center.m_123341_(), 2.0) + Math.pow(pos.m_123343_() - center.m_123343_(), 2.0));
        double ringWidth = maxRadius / (float)rings.size();
        double idealRingIndex = distance / ringWidth;
        int primaryRing = Math.min(Math.max((int)idealRingIndex, 0), rings.size() - 1);
        rings.get(primaryRing).add(pos);
        double distanceToBoundary = Math.abs(idealRingIndex - (double)primaryRing);
        float overlapThreshold = 0.2f;
        if (primaryRing < rings.size() - 1 && distanceToBoundary > 1.0 - (double)overlapThreshold) {
            rings.get(primaryRing + 1).add(pos);
        }
        if (primaryRing > 0 && distanceToBoundary > 1.0 - (double)overlapThreshold) {
            rings.get(primaryRing - 1).add(pos);
        }
    }

    private static void processAllRingsBatched(ServerLevel level, BlockPos centerPos, List<Set<BlockPos>> rings, Set<BlockPos> craterBlocksSet, Block[] selafitBlocks, RandomSource random, float topRemovalRadius, int craterDepth, Block wasteLogBlock, Block wastePlanksBlock, Block burnedGrassBlock) {
        ArrayList<BlockPos> blockBatch = new ArrayList<BlockPos>(256);
        for (int ringIndex = 0; ringIndex < rings.size(); ++ringIndex) {
            Set<BlockPos> currentRing = rings.get(ringIndex);
            if (currentRing.isEmpty()) continue;
            blockBatch.clear();
            for (BlockPos pos : currentRing) {
                blockBatch.add(pos);
                if (blockBatch.size() < 256) continue;
                DudCraterGenerator.removeBlocksBatch(level, blockBatch);
                blockBatch.clear();
            }
            if (!blockBatch.isEmpty()) {
                DudCraterGenerator.removeBlocksBatch(level, blockBatch);
            }
            if (ringIndex == 1) {
                for (BlockPos pos : currentRing) {
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_204336_(BlockTags.f_13035_)) continue;
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                DudCraterGenerator.generateSelafitAtBottom(level, centerPos, currentRing, craterBlocksSet, selafitBlocks, random, craterDepth);
                continue;
            }
            if (ringIndex < 2) continue;
            DudCraterGenerator.generateSelafitAtBottom(level, centerPos, currentRing, craterBlocksSet, selafitBlocks, random, craterDepth);
        }
    }

    private static void removeBlocksBatch(ServerLevel level, List<BlockPos> batch) {
        for (BlockPos pos : batch) {
            level.m_7471_(pos, false);
        }
    }

    private static void generateSelafitAtBottom(ServerLevel level, BlockPos centerPos, Set<BlockPos> ringBlocks, Set<BlockPos> craterBlocksSet, Block[] selafitBlocks, RandomSource random, int craterDepth) {
        int centerY = centerPos.m_123342_();
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        for (BlockPos pos : ringBlocks) {
            double maxDistance;
            if (craterBlocksSet.contains(pos.m_7495_()) || !DudCraterGenerator.hasValidGroundBelow(level, pos.m_7495_())) continue;
            int targetX = pos.m_123341_();
            int targetZ = pos.m_123343_();
            int bottomY = centerY - craterDepth;
            BlockPos destPos = null;
            for (int y = bottomY; y <= centerY; ++y) {
                BlockPos checkPos = new BlockPos(targetX, y, targetZ);
                BlockState checkState = level.m_8055_(checkPos);
                if (!checkState.m_60819_().m_76178_()) {
                    level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                    continue;
                }
                if (!checkState.m_60795_()) continue;
                BlockPos belowPos = checkPos.m_7495_();
                for (int depthCheck = 0; depthCheck < 60; ++depthCheck) {
                    BlockPos checkBelow = belowPos.m_6625_(depthCheck);
                    BlockState belowState = level.m_8055_(checkBelow);
                    if (belowState.m_60795_() || !belowState.m_60804_((BlockGetter)level, checkBelow)) continue;
                    destPos = checkPos;
                    break;
                }
                if (destPos != null) break;
            }
            if (destPos == null) continue;
            double distance = Math.sqrt(Math.pow(targetX - centerX, 2.0) + Math.pow(targetZ - centerZ, 2.0));
            double ratio = Math.min(distance / (maxDistance = (double)craterDepth * 1.5), 1.0);
            int layers = (int)((1.0 - ratio) * 4.0);
            if (layers < 1) {
                layers = 1;
            }
            Block selafitBlock = selafitBlocks[random.m_188503_(selafitBlocks.length)];
            DudCraterGenerator.placeSelafitLayers(level, destPos, selafitBlock, layers, craterBlocksSet);
        }
    }

    private static boolean hasValidGroundBelow(ServerLevel level, BlockPos below) {
        for (int y = -50; y <= 1; ++y) {
            BlockPos checkPos = below.m_6630_(y);
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_60795_() || !checkState.m_60804_((BlockGetter)level, checkPos)) continue;
            return true;
        }
        return false;
    }

    private static void placeSelafitLayers(ServerLevel level, BlockPos basePos, Block selafitBlock, int layerCount, Set<BlockPos> craterBlocksSet) {
        BlockPos layerPos;
        BlockState layerState;
        for (int layer = 0; layer < layerCount && ((layerState = level.m_8055_(layerPos = basePos.m_6630_(layer))).m_60795_() || layerState.m_204336_(BlockTags.f_278394_)); ++layer) {
            level.m_7731_(layerPos, selafitBlock.m_49966_(), 3);
            craterBlocksSet.add(layerPos);
        }
    }

    private static void removeItemsInRadiusBatched(ServerLevel level, BlockPos centerPos, int radius) {
        AABB removalArea = new AABB((double)(centerPos.m_123341_() - radius), (double)(centerPos.m_123342_() - 100), (double)(centerPos.m_123343_() - radius), (double)(centerPos.m_123341_() + radius), (double)(centerPos.m_123342_() + 100), (double)(centerPos.m_123343_() + radius));
        List items = level.m_45976_(ItemEntity.class, removalArea);
        int discardedCount = 0;
        for (ItemEntity item : items) {
            item.m_146870_();
            if (++discardedCount % 100 != 0) continue;
            Thread.yield();
        }
        System.out.println("[CRATER] \u0423\u0434\u0430\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: " + discardedCount);
    }

    private static void applyDamageZonesOptimizedV2(ServerLevel level, BlockPos centerPos, Block wasteLogBlock, Block wastePlanksBlock, Block burnedGrassBlock, Block[] selafitBlocks, RandomSource random) {
        System.out.println("[CRATER] \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u043e\u043d \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f \u043d\u0430\u0447\u0430\u0442\u043e!");
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        int searchRadius = 160;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            long dx = x - centerX;
            long dxSq = dx * dx;
            if (dxSq > 19600L) continue;
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                long dz = z - centerZ;
                long distanceSq = dxSq + dz * dz;
                if (distanceSq > 19600L) continue;
                for (int y = centerY - 100; y <= centerY + 80 + 60; ++y) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (distanceSq <= 7225L) {
                        if (state.m_204336_(BlockTags.f_13035_)) {
                            level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_50195_) || state.m_204336_(BlockTags.f_13090_) || state.m_204336_(BlockTags.f_13106_) || state.m_60713_(Blocks.f_50062_) || state.m_60713_(Blocks.f_50652_) || state.m_60713_(Blocks.f_49994_)) {
                            Block selafitBlock = selafitBlocks[random.m_188503_(selafitBlocks.length)];
                            level.m_7731_(checkPos, selafitBlock.m_49966_(), 3);
                            continue;
                        }
                        if (!state.m_60713_(Blocks.f_50034_) && !state.m_60713_(Blocks.f_50359_) && !state.m_60713_(Blocks.f_50037_) && !state.m_60713_(Blocks.f_50038_) && !state.m_60713_(Blocks.f_50125_) && !state.m_60713_(Blocks.f_50127_)) continue;
                        level.m_7471_(checkPos, false);
                        continue;
                    }
                    if (distanceSq > 19600L) continue;
                    if (state.m_204336_(BlockTags.f_13035_)) {
                        if (random.m_188501_() < 0.4f) {
                            level.m_7471_(checkPos, false);
                            continue;
                        }
                        if (!(random.m_188501_() < 0.1f)) continue;
                        level.m_7731_(checkPos, Blocks.f_50083_.m_49966_(), 3);
                        continue;
                    }
                    if (state.m_60713_(Blocks.f_50440_)) {
                        level.m_7731_(checkPos, burnedGrassBlock.m_49966_(), 3);
                        continue;
                    }
                    if (state.m_204336_(BlockTags.f_13106_)) {
                        level.m_7731_(checkPos, wasteLogBlock.m_49966_(), 3);
                        continue;
                    }
                    if (state.m_204336_(BlockTags.f_13090_)) {
                        level.m_7731_(checkPos, wastePlanksBlock.m_49966_(), 3);
                        continue;
                    }
                    if (state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_) || state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50599_)) {
                        level.m_7471_(checkPos, false);
                        continue;
                    }
                    if (state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13037_)) {
                        level.m_7471_(checkPos, false);
                        continue;
                    }
                    if (!state.m_60713_(Blocks.f_50058_) && !state.m_60713_(Blocks.f_50185_) || !(random.m_188501_() < 0.6f)) continue;
                    level.m_7471_(checkPos, false);
                }
            }
        }
        AABB zone3Area = new AABB((double)(centerX - 85), (double)(centerY - 80), (double)(centerZ - 85), (double)(centerX + 85), (double)(centerY + 80), (double)(centerZ + 85));
        List itemsZone3 = level.m_45976_(ItemEntity.class, zone3Area);
        for (ItemEntity item : itemsZone3) {
            item.m_146870_();
        }
        AABB zone4Area = new AABB((double)(centerX - 140), (double)(centerY - 80), (double)(centerZ - 140), (double)(centerX + 140), (double)(centerY + 80), (double)(centerZ + 140));
        List itemsZone4 = level.m_45976_(ItemEntity.class, zone4Area);
        for (ItemEntity item : itemsZone4) {
            item.m_146870_();
        }
        DudCraterGenerator.applyKillZoneToEntitiesOptimized(level, centerPos, random);
        System.out.println("[CRATER] \u2705 \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u043e\u043d \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e!");
    }

    private static void applyZone4Effects(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if (state.m_204336_(BlockTags.f_13035_)) {
            if (random.m_188501_() < 0.4f) {
                level.m_7471_(pos, false);
            } else if (random.m_188501_() < 0.1f) {
                level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            }
        } else if (state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_) || state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50599_)) {
            level.m_7471_(pos, false);
        } else if (state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13037_)) {
            level.m_7471_(pos, false);
        } else if ((state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_50185_)) && random.m_188501_() < 0.6f) {
            level.m_7471_(pos, false);
        }
    }

    private static void applyKillZoneToEntitiesOptimized(ServerLevel level, BlockPos centerPos, RandomSource random) {
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        AABB zone3Area = new AABB((double)(centerX - 85), (double)(centerY - 80), (double)(centerZ - 85), (double)(centerX + 85), (double)(centerY + 80), (double)(centerZ + 85));
        AABB zone4Area = new AABB((double)(centerX - 140), (double)(centerY - 80), (double)(centerZ - 140), (double)(centerX + 140), (double)(centerY + 80), (double)(centerZ + 140));
        List entitiesZone3 = level.m_45976_(LivingEntity.class, zone3Area);
        for (LivingEntity entity : entitiesZone3) {
            entity.m_6469_(level.m_269111_().m_269264_(), 500.0f);
            entity.m_20254_(1);
        }
        List entitiesZone4 = level.m_45976_(LivingEntity.class, zone4Area);
        for (LivingEntity entity : entitiesZone4) {
            if (entitiesZone3.contains(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269264_(), 200.0f);
            entity.m_20254_(1);
        }
    }
}

