/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class EnergyFormatter {
    private static final String[] SUFFIXES = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final long[] THRESHOLDS = new long[]{1L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final DecimalFormat df0 = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.US));
    private static final DecimalFormat df1 = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.US));
    private static final DecimalFormat df2 = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));

    public static String format(long energy) {
        if (energy < 0L) {
            return "-" + EnergyFormatter.format(-energy);
        }
        if (energy < 1000L) {
            return String.valueOf(energy);
        }
        int suffixIndex = 0;
        int i = 1;
        while (i < THRESHOLDS.length && energy >= THRESHOLDS[i]) {
            suffixIndex = i++;
        }
        double value = (double)energy / (double)THRESHOLDS[suffixIndex];
        String formatted = value >= 100.0 ? df0.format(value) : (value >= 10.0 ? df1.format(value) : df2.format(value));
        return formatted + SUFFIXES[suffixIndex];
    }

    public static String formatWithUnit(long energy, String unit) {
        return EnergyFormatter.format(energy) + " " + unit;
    }

    public static String formatFE(long energy) {
        return EnergyFormatter.formatWithUnit(energy, "HE");
    }

    public static String formatRate(long rate) {
        return EnergyFormatter.formatWithUnit(rate, "HE/t");
    }
}

