/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ExplosionResistanceRegistry {
    private static final Map<Block, Integer> BLOCK_RESISTANCE = new HashMap<Block, Integer>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50752_, 15);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50722_, 15);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50080_, 15);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50723_, 15);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_220863_, 15);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152550_, 14);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50379_, 14);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50377_, 13);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50492_, 13);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50730_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50137_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50069_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50122_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50228_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50334_, 12);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50734_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49996_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152468_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50089_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152474_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50264_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152479_, 11);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50059_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152472_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50173_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152473_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49995_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152467_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152505_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152506_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49997_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152469_, 10);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50652_, 9);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50079_, 9);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152551_, 9);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50076_, 8);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50197_, 8);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50452_, 8);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50352_, 8);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50134_, 7);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50259_, 7);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50062_, 7);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50394_, 7);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49994_, 6);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50493_, 6);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_152549_, 6);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_220864_, 6);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49992_, 5);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49993_, 5);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50135_, 5);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_49999_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50001_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50000_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50002_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50003_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50004_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_220832_, 4);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50705_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50742_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50741_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50743_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50744_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50745_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_220865_, 3);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50058_, 2);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50542_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50543_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50544_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50545_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50494_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50495_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50496_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50497_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50498_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50499_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50500_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50501_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50502_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50503_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50504_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50505_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50440_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50599_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50195_, 1);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50359_, 0);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50125_, 0);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50038_, 0);
        ExplosionResistanceRegistry.registerBlock(Blocks.f_50037_, 0);
    }

    public static void registerBlock(Block block, int resistance) {
        if (resistance < 0 || resistance > 15) {
            throw new IllegalArgumentException("\u041f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 15, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e: " + resistance);
        }
        BLOCK_RESISTANCE.put(block, resistance);
    }

    public static int getResistance(Block block) {
        return BLOCK_RESISTANCE.getOrDefault(block, 7);
    }

    public static boolean isIndestructible(Block block) {
        return ExplosionResistanceRegistry.getResistance(block) >= 15;
    }

    public static boolean isShieldBlock(Block block) {
        int resistance = ExplosionResistanceRegistry.getResistance(block);
        return resistance >= 6 && resistance <= 10;
    }

    public static boolean isStrongBlock(Block block) {
        int resistance = ExplosionResistanceRegistry.getResistance(block);
        return resistance >= 10 && resistance < 15;
    }

    public static Map<Block, Integer> getAllBlocks() {
        return new HashMap<Block, Integer>(BLOCK_RESISTANCE);
    }
}

