/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MessGenerator {
    public static void generateCrater(ServerLevel level, BlockPos centerPos, int radius, int depth, Block surfaceBlock1, Block surfaceBlock2, Block surfaceBlock3) {
        RandomSource random = level.f_46441_;
        ArrayList<BlockPos> craterBlocks = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -depth; y <= radius; ++y) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double distance = Math.sqrt(x * x + z * z + y * y);
                    if (y <= 0) {
                        if (!(distance <= (double)radius)) continue;
                        craterBlocks.add(checkPos);
                        continue;
                    }
                    double edgeRadius = (double)radius * (1.0 - (double)y / (double)radius * 0.3);
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    if (!(horizontalDistance <= edgeRadius) || !((double)y < (double)radius * 0.2)) continue;
                    craterBlocks.add(checkPos);
                }
            }
        }
        craterBlocks.sort((pos1, pos2) -> {
            double dist1 = centerPos.m_123331_((Vec3i)pos1);
            double dist2 = centerPos.m_123331_((Vec3i)pos2);
            return Double.compare(dist2, dist1);
        });
        int blocksPerTick = Math.max(1, craterBlocks.size() / 40);
        MessGenerator.removeCraterBlocks(level, craterBlocks, blocksPerTick, 0, surfaceBlock1, surfaceBlock2, surfaceBlock3, centerPos);
    }

    private static void removeCraterBlocks(ServerLevel level, List<BlockPos> blocks, int blocksPerTick, int currentIndex, Block surfaceBlock1, Block surfaceBlock2, Block surfaceBlock3, BlockPos centerPos) {
        if (currentIndex >= blocks.size()) {
            MessGenerator.generateCraterSurface(level, centerPos, blocks, surfaceBlock1, surfaceBlock2, surfaceBlock3);
            return;
        }
        int endIndex = Math.min(currentIndex + blocksPerTick, blocks.size());
        for (int i = currentIndex; i < endIndex; ++i) {
            BlockPos pos = blocks.get(i);
            BlockState state = level.m_8055_(pos);
            if (!(state.m_60800_((BlockGetter)level, pos) >= 0.0f)) continue;
            level.m_7471_(pos, false);
        }
        int nextIndex = endIndex;
        if (level.m_7654_() != null) {
            level.m_7654_().m_6937_((Runnable)new TickTask(1, () -> MessGenerator.removeCraterBlocks(level, blocks, blocksPerTick, nextIndex, surfaceBlock1, surfaceBlock2, surfaceBlock3, centerPos)));
        }
    }

    private static void generateCraterSurface(ServerLevel level, BlockPos centerPos, List<BlockPos> craterBlocks, Block surfaceBlock1, Block surfaceBlock2, Block surfaceBlock3) {
        RandomSource random = level.f_46441_;
        Block[] surfaceBlocks = new Block[]{surfaceBlock1, surfaceBlock2, surfaceBlock3};
        HashSet<BlockPos> craterBlocksSet = new HashSet<BlockPos>(craterBlocks);
        for (BlockPos pos : craterBlocks) {
            boolean wasNotRemoved;
            BlockPos above = pos.m_7494_();
            boolean isAirAbove = level.m_8055_(above).m_60795_();
            boolean bl = wasNotRemoved = !craterBlocksSet.contains(above);
            if (!isAirAbove && !wasNotRemoved) continue;
            Block randomBlock = surfaceBlocks[random.m_188503_(surfaceBlocks.length)];
            level.m_7731_(pos, randomBlock.m_49966_(), 3);
        }
    }

    public static void generateCraterInstant(ServerLevel level, BlockPos centerPos, int radius, int depth, Block surfaceBlock1, Block surfaceBlock2, Block surfaceBlock3) {
        RandomSource random = level.f_46441_;
        Block[] surfaceBlocks = new Block[]{surfaceBlock1, surfaceBlock2, surfaceBlock3};
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -depth; y <= radius; ++y) {
                    BlockState state;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double distance = Math.sqrt(x * x + z * z + y * y);
                    boolean shouldRemove = false;
                    if (y <= 0) {
                        if (distance <= (double)radius) {
                            shouldRemove = true;
                        }
                    } else {
                        double edgeRadius = (double)radius * (1.0 - (double)y / (double)radius * 0.3);
                        double horizontalDistance = Math.sqrt(x * x + z * z);
                        if (horizontalDistance <= edgeRadius && (double)y < (double)radius * 0.2) {
                            shouldRemove = true;
                        }
                    }
                    if (!shouldRemove || !((state = level.m_8055_(checkPos)).m_60800_((BlockGetter)level, checkPos) >= 0.0f)) continue;
                    BlockPos above = checkPos.m_7494_();
                    boolean isAirAbove = level.m_8055_(above).m_60795_();
                    if (isAirAbove) {
                        Block randomBlock = surfaceBlocks[random.m_188503_(surfaceBlocks.length)];
                        level.m_7731_(checkPos, randomBlock.m_49966_(), 3);
                        continue;
                    }
                    level.m_7471_(checkPos, false);
                }
            }
        }
    }
}

