/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class SellafitSolidificationTracker {
    private static final Map<Long, Integer> chunkSolidificationTime = new ConcurrentHashMap<Long, Integer>();
    private static final int SELLAFIT_SOLIDIFICATION_TICKS = 200;
    private static final int SAFETY_MARGIN_TICKS = 20;
    private static final int TOTAL_SOLIDIFICATION_TICKS = 220;
    private static volatile int cachedSize = 0;

    public static void registerChunkStart(ServerLevel level, int chunkX, int chunkZ) {
        long chunkKey = SellafitSolidificationTracker.getChunkKey(chunkX, chunkZ);
        int currentTick = (int)(level.m_46467_() & Integer.MAX_VALUE);
        chunkSolidificationTime.put(chunkKey, currentTick);
        ++cachedSize;
    }

    public static boolean isChunkSolidified(ServerLevel level, int chunkX, int chunkZ) {
        long chunkKey = SellafitSolidificationTracker.getChunkKey(chunkX, chunkZ);
        Integer startTickObj = chunkSolidificationTime.get(chunkKey);
        if (startTickObj == null) {
            return true;
        }
        int startTick = startTickObj;
        int currentTick = (int)(level.m_46467_() & Integer.MAX_VALUE);
        int elapsedTicks = currentTick - startTick;
        if (elapsedTicks < 0) {
            elapsedTicks += Integer.MAX_VALUE;
        }
        return elapsedTicks >= 220;
    }

    public static int getRemainingTicks(ServerLevel level, int chunkX, int chunkZ) {
        long chunkKey = SellafitSolidificationTracker.getChunkKey(chunkX, chunkZ);
        Integer startTickObj = chunkSolidificationTime.get(chunkKey);
        if (startTickObj == null) {
            return 0;
        }
        int startTick = startTickObj;
        int currentTick = (int)(level.m_46467_() & Integer.MAX_VALUE);
        int elapsedTicks = currentTick - startTick;
        if (elapsedTicks < 0) {
            elapsedTicks += Integer.MAX_VALUE;
        }
        return Math.max(0, 220 - elapsedTicks);
    }

    public static void clearChunk(int chunkX, int chunkZ) {
        long chunkKey = SellafitSolidificationTracker.getChunkKey(chunkX, chunkZ);
        if (chunkSolidificationTime.remove(chunkKey) != null) {
            --cachedSize;
        }
    }

    private static long getChunkKey(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static int[] getChunkCoordinates(BlockPos pos) {
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        return new int[]{chunkX, chunkZ};
    }

    public static int getChunkX(BlockPos pos) {
        return pos.m_123341_() >> 4;
    }

    public static int getChunkZ(BlockPos pos) {
        return pos.m_123343_() >> 4;
    }

    public static boolean isChunkRegistered(int chunkX, int chunkZ) {
        return chunkSolidificationTime.containsKey(SellafitSolidificationTracker.getChunkKey(chunkX, chunkZ));
    }

    public static int getTrackedChunksCount() {
        return cachedSize;
    }

    public static void clearAll() {
        chunkSolidificationTime.clear();
        cachedSize = 0;
    }

    public static Set<Long> getAllTrackedChunks() {
        return new HashSet<Long>(chunkSolidificationTime.keySet());
    }

    public static void cleanupOldEntries(ServerLevel level) {
        int currentTick = (int)(level.m_46467_() & Integer.MAX_VALUE);
        int cleanupThreshold = 820;
        ArrayList<Long> keysToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, Integer> entry : chunkSolidificationTime.entrySet()) {
            int elapsedTicks = currentTick - entry.getValue();
            if (elapsedTicks < 0) {
                elapsedTicks += Integer.MAX_VALUE;
            }
            if (elapsedTicks <= cleanupThreshold) continue;
            keysToRemove.add(entry.getKey());
        }
        for (Long key : keysToRemove) {
            chunkSolidificationTime.remove(key);
            --cachedSize;
        }
        if (!keysToRemove.isEmpty()) {
            System.out.println("[SELLAFIT] \u041e\u0447\u0438\u0449\u0435\u043d\u043e \u0441\u0442\u0430\u0440\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + keysToRemove.size());
        }
    }
}

