/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.util.BlockExplosionDefense;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ShockwaveGenerator {
    private static final int ZONE_3_RADIUS = 25;
    private static final int ZONE_4_RADIUS = 35;
    private static final int DAMAGE_ZONE_HEIGHT = 20;

    public static void generateCrater(ServerLevel level, BlockPos centerPos, int craterRadius, int craterDepth, Block wasteLogBlock, Block wastePlanksBlock, Block burnedGrass) {
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        RandomSource random = level.f_46441_;
        for (int x = centerX - craterRadius; x <= centerX + craterRadius; ++x) {
            for (int y = centerY - craterRadius; y <= centerY + craterRadius; ++y) {
                for (int z = centerZ - craterRadius; z <= centerZ + craterRadius; ++z) {
                    double noise;
                    double norm;
                    double smoothDepth;
                    double dx = x - centerX;
                    double dy = y - centerY;
                    double dz = z - centerZ;
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (dist > (double)craterRadius || !(dist <= (smoothDepth = (double)craterDepth * Math.cos((norm = dist / (double)craterRadius) * Math.PI / 2.0)) + (noise = (random.m_188500_() - 0.5) * 2.0))) continue;
                    BlockPos checkPos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    BlockExplosionDefense.ExplosionDefenseResult defenseResult = BlockExplosionDefense.calculateExplosionDamage(level, checkPos, centerPos, craterRadius, random);
                    if (!defenseResult.shouldBreak || state.m_60795_()) continue;
                    level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        ShockwaveGenerator.applyDamageZones(level, centerPos, wasteLogBlock, wastePlanksBlock, burnedGrass);
    }

    private static void applyDamageZones(ServerLevel level, BlockPos centerPos, Block wasteLogBlock, Block wastePlanksBlock, Block burnedGrass) {
        int centerX = centerPos.m_123341_();
        int centerY = centerPos.m_123342_();
        int centerZ = centerPos.m_123343_();
        int searchRadius = 35;
        int topSearchHeight = 60;
        int bottomSearchHeight = 20;
        RandomSource random = level.f_46441_;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                for (int y = centerY - bottomSearchHeight; y <= centerY + topSearchHeight; ++y) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    double dx = x - centerX;
                    double dz = z - centerZ;
                    double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
                    if (horizontalDistance > 35.0) continue;
                    BlockState state = level.m_8055_(checkPos);
                    BlockExplosionDefense.ExplosionDefenseResult defenseResult = BlockExplosionDefense.calculateExplosionDamage(level, checkPos, centerPos, 35.0f, random);
                    if (!defenseResult.shouldBreak) continue;
                    if (horizontalDistance <= 25.0) {
                        if (state.m_204336_(BlockTags.f_13035_)) {
                            level.m_7731_(checkPos, Blocks.f_50083_.m_49966_(), 3);
                            continue;
                        }
                        if (state.m_204336_(BlockTags.f_13106_)) {
                            level.m_7731_(checkPos, wasteLogBlock.m_49966_(), 3);
                            continue;
                        }
                        if (state.m_204336_(BlockTags.f_13090_)) {
                            level.m_7731_(checkPos, wastePlanksBlock.m_49966_(), 3);
                            continue;
                        }
                        if (!state.m_60713_(Blocks.f_50440_)) continue;
                        level.m_7731_(checkPos, burnedGrass.m_49966_(), 3);
                        continue;
                    }
                    if (!(horizontalDistance <= 35.0) || !state.m_204336_(BlockTags.f_13035_)) continue;
                    if (random.m_188501_() < 0.4f) {
                        level.m_7471_(checkPos, false);
                        continue;
                    }
                    if (!(random.m_188501_() < 0.2f)) continue;
                    level.m_7731_(checkPos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
        }
    }
}

