/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.recipe.AssemblerRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TemplateTooltipUtil {
    public static void buildTemplateTooltip(ItemStack stack, Level level, List<Component> tooltip) {
        if (level == null) {
            return;
        }
        ItemStack output = ItemAssemblyTemplate.getRecipeOutput(stack);
        if (output.m_41619_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.template_broken").m_130940_(ChatFormatting.RED));
            return;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional<AssemblerRecipe> recipeOpt = recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE).stream().filter(r -> ItemStack.m_150942_((ItemStack)r.m_8043_(null), (ItemStack)output)).findFirst();
        if (recipeOpt.isEmpty()) {
            return;
        }
        AssemblerRecipe recipe = recipeOpt.get();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.created_with_template_folder").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237119_());
        TemplateTooltipUtil.addRecipeDetails(recipe, output, tooltip);
    }

    public static void buildRecipeTooltip(AssemblerRecipe recipe, List<Component> tooltip) {
        if (recipe == null) {
            return;
        }
        ItemStack output = recipe.m_8043_(null);
        if (output.m_41619_()) {
            return;
        }
        TemplateTooltipUtil.addRecipeDetails(recipe, output, tooltip);
    }

    private static void addRecipeDetails(AssemblerRecipe recipe, ItemStack output, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.output").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)("  " + output.m_41613_() + "x ")).m_130940_(ChatFormatting.WHITE).m_7220_(output.m_41786_()));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.input").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        HashMap<Item, Integer> ingredientMap = new HashMap<Item, Integer>();
        for (Ingredient ing : ingredients) {
            if (ing.m_43908_().length <= 0) continue;
            Item item = ing.m_43908_()[0].m_41720_();
            int count = ing.m_43908_()[0].m_41613_();
            ingredientMap.merge(item, count, Integer::sum);
        }
        for (Map.Entry entry : ingredientMap.entrySet()) {
            ItemStack ingredientStack = new ItemStack((ItemLike)entry.getKey());
            tooltip.add((Component)Component.m_237113_((String)("  " + String.valueOf(entry.getValue()) + "x ")).m_130940_(ChatFormatting.WHITE).m_7220_(ingredientStack.m_41786_()));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.production_time").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        int timeInTicks = recipe.getDuration();
        float timeInSeconds = (float)timeInTicks / 20.0f;
        String formattedTime = String.format("%.1f", Float.valueOf(timeInSeconds));
        tooltip.add((Component)Component.m_237113_((String)("  " + formattedTime + " ")).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltip.hbm_m.seconds")));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.energy_consumption").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        int powerConsumption = recipe.getPowerConsumption();
        tooltip.add((Component)Component.m_237113_((String)("  " + TemplateTooltipUtil.formatEnergy(powerConsumption) + " HE/t")).m_130940_(ChatFormatting.YELLOW));
    }

    private static String formatEnergy(int energy) {
        if (energy >= 1000000) {
            return String.format("%.1fM", (double)energy / 1000000.0);
        }
        if (energy >= 1000) {
            return String.format("%.1fK", (double)energy / 1000.0);
        }
        return String.valueOf(energy);
    }
}

