/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.util.ExplosionResistanceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WasteBlastGenerator {
    private static final int SURFACE_LAYER_DEPTH = 4;

    private static boolean isWaterBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_49990_;
    }

    private static boolean isAirBlock(BlockState state) {
        return state.m_60795_();
    }

    public static void generateCraterInstant(ServerLevel level, BlockPos centerPos, int radius, int depth, Block[] sellafieldBlocks) {
        RandomSource random = level.f_46441_;
        ExplosionResistanceRegistry.init();
        if (sellafieldBlocks.length != 4) {
            throw new IllegalArgumentException("sellafieldBlocks \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0440\u043e\u0432\u043d\u043e 4 \u0431\u043b\u043e\u043a\u0430");
        }
        HashSet<BlockPos> removedBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> upperPartBlocks = new HashSet<BlockPos>();
        HashMap<BlockPos, Integer> blocksToProcess = new HashMap<BlockPos, Integer>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -depth; y <= radius * 2; ++y) {
                    BlockState state;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    boolean shouldCheck = false;
                    boolean isUpperPart = false;
                    if (y <= 0) {
                        double normalizedDepth = (double)(-y) / (double)depth;
                        double depthRadius = (double)radius * (1.0 - normalizedDepth * normalizedDepth);
                        if (horizontalDistance <= depthRadius) {
                            shouldCheck = true;
                        }
                    } else {
                        double edgeRadius = (double)radius * Math.max(0.0, 1.0 - (double)y / (double)(radius * 2));
                        if (horizontalDistance <= edgeRadius) {
                            shouldCheck = true;
                            isUpperPart = true;
                        }
                    }
                    if (!shouldCheck || WasteBlastGenerator.isWaterBlock(state = level.m_8055_(checkPos)) || WasteBlastGenerator.isAirBlock(state)) continue;
                    if (isUpperPart) {
                        upperPartBlocks.add(checkPos);
                    }
                    double distanceFromCenter = Math.sqrt(x * x + y * y + z * z);
                    int distanceKey = (int)Math.round(distanceFromCenter);
                    blocksToProcess.put(checkPos, distanceKey);
                }
            }
        }
        WasteBlastGenerator.processBlocksWithShielding(level, blocksToProcess, removedBlocks, upperPartBlocks, centerPos, radius);
        WasteBlastGenerator.generateCraterSurfaceInstant(level, removedBlocks, upperPartBlocks, sellafieldBlocks, random);
    }

    private static void processBlocksWithShielding(ServerLevel level, Map<BlockPos, Integer> blocksToProcess, Set<BlockPos> removedBlocks, Set<BlockPos> upperPartBlocks, BlockPos centerPos, int radius) {
        RandomSource random = level.f_46441_;
        ArrayList<Map.Entry<BlockPos, Integer>> sortedBlocks = new ArrayList<Map.Entry<BlockPos, Integer>>(blocksToProcess.entrySet());
        sortedBlocks.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        HashSet<BlockPos> protectedBlocks = new HashSet<BlockPos>();
        for (Map.Entry entry : sortedBlocks) {
            BlockPos pos = (BlockPos)entry.getKey();
            Block block = level.m_8055_(pos).m_60734_();
            int resistance = ExplosionResistanceRegistry.getResistance(block);
            if (resistance >= 15) {
                protectedBlocks.add(pos);
                continue;
            }
            if (protectedBlocks.contains(pos) && WasteBlastGenerator.isBlockShielded(level, centerPos, pos, protectedBlocks)) {
                protectedBlocks.add(pos);
                continue;
            }
            float survivalChance = WasteBlastGenerator.calculateSurvivalChance(resistance, (Integer)entry.getValue(), radius);
            if (random.m_188501_() < survivalChance) {
                protectedBlocks.add(pos);
                if (resistance < 6 || resistance >= 15) continue;
                WasteBlastGenerator.protectNearbyBlocks(pos, protectedBlocks, level, centerPos);
                continue;
            }
            level.m_7471_(pos, false);
            removedBlocks.add(pos);
        }
    }

    private static boolean isBlockShielded(ServerLevel level, BlockPos centerPos, BlockPos targetPos, Set<BlockPos> protectedBlocks) {
        int dz;
        int dy;
        int dx = targetPos.m_123341_() - centerPos.m_123341_();
        double distance = Math.sqrt(dx * dx + (dy = targetPos.m_123342_() - centerPos.m_123342_()) * dy + (dz = targetPos.m_123343_() - centerPos.m_123343_()) * dz);
        if (distance < 1.0) {
            return false;
        }
        double ndx = (double)dx / distance;
        double ndy = (double)dy / distance;
        double ndz = (double)dz / distance;
        for (double d = 0.5; d < distance; d += 1.0) {
            Block shieldBlock;
            int shieldResistance;
            int checkZ;
            int checkY;
            int checkX = centerPos.m_123341_() + (int)Math.round(ndx * d);
            BlockPos checkPos = new BlockPos(checkX, checkY = centerPos.m_123342_() + (int)Math.round(ndy * d), checkZ = centerPos.m_123343_() + (int)Math.round(ndz * d));
            if (!protectedBlocks.contains(checkPos) || (shieldResistance = ExplosionResistanceRegistry.getResistance(shieldBlock = level.m_8055_(checkPos).m_60734_())) < 10 || shieldResistance >= 15) continue;
            return true;
        }
        return false;
    }

    private static void protectNearbyBlocks(BlockPos shieldPos, Set<BlockPos> protectedBlocks, ServerLevel level, BlockPos centerPos) {
        int shieldDistance = 3;
        for (int x = -shieldDistance; x <= shieldDistance; ++x) {
            for (int y = -shieldDistance; y <= shieldDistance; ++y) {
                for (int z = -shieldDistance; z <= shieldDistance; ++z) {
                    BlockPos nearbyPos;
                    if (x == 0 && y == 0 && z == 0 || !WasteBlastGenerator.isInShadow(centerPos, shieldPos, nearbyPos = shieldPos.m_7918_(x, y, z))) continue;
                    protectedBlocks.add(nearbyPos);
                }
            }
        }
    }

    private static boolean isInShadow(BlockPos centerPos, BlockPos shieldPos, BlockPos targetPos) {
        int sX = shieldPos.m_123341_() - centerPos.m_123341_();
        int sY = shieldPos.m_123342_() - centerPos.m_123342_();
        int sZ = shieldPos.m_123343_() - centerPos.m_123343_();
        int tX = targetPos.m_123341_() - centerPos.m_123341_();
        int tY = targetPos.m_123342_() - centerPos.m_123342_();
        int tZ = targetPos.m_123343_() - centerPos.m_123343_();
        int dotProduct = sX * tX + sY * tY + sZ * tZ;
        double shieldDist = Math.sqrt(sX * sX + sY * sY + sZ * sZ);
        double targetDist = Math.sqrt(tX * tX + tY * tY + tZ * tZ);
        return dotProduct > 0 && targetDist > shieldDist * 0.8;
    }

    private static float calculateSurvivalChance(int resistance, int distanceFromCenter, int maxRadius) {
        float normalizedDistance = Math.min(1.0f, (float)distanceFromCenter / (float)maxRadius);
        float survivalChance = 0.0f;
        switch (resistance) {
            case 0: {
                survivalChance = 0.0f;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                survivalChance = normalizedDistance * 0.2f;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                survivalChance = 0.3f + normalizedDistance * 0.4f;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                survivalChance = 0.6f + normalizedDistance * 0.35f;
                break;
            }
            case 15: {
                survivalChance = 1.0f;
            }
        }
        return survivalChance;
    }

    private static void generateCraterSurfaceInstant(ServerLevel level, Set<BlockPos> removedBlocks, Set<BlockPos> upperPartBlocks, Block[] sellafieldBlocks, RandomSource random) {
        HashSet<BlockPos> bottomBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : removedBlocks) {
            BlockPos below;
            if (upperPartBlocks.contains(pos) || removedBlocks.contains(below = pos.m_7495_())) continue;
            bottomBlocks.add(pos);
        }
        for (BlockPos bottomPos : bottomBlocks) {
            Block randomBlock = sellafieldBlocks[random.m_188503_(sellafieldBlocks.length)];
            level.m_7731_(bottomPos, randomBlock.m_49966_(), 3);
            BlockPos currentPos = bottomPos.m_7494_();
            for (int layer = 1; layer < 4 && removedBlocks.contains(currentPos) && !upperPartBlocks.contains(currentPos); ++layer) {
                randomBlock = sellafieldBlocks[random.m_188503_(sellafieldBlocks.length)];
                level.m_7731_(currentPos, randomBlock.m_49966_(), 3);
                currentPos = currentPos.m_7494_();
            }
        }
    }

    public static void generateCrater(ServerLevel level, BlockPos centerPos, int radius, int depth, Block[] sellafieldBlocks) {
        RandomSource random = level.f_46441_;
        ExplosionResistanceRegistry.init();
        if (sellafieldBlocks.length != 4) {
            throw new IllegalArgumentException("sellafieldBlocks \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0440\u043e\u0432\u043d\u043e 4 \u0431\u043b\u043e\u043a\u0430");
        }
        HashMap<BlockPos, Integer> blocksToProcess = new HashMap<BlockPos, Integer>();
        HashSet<BlockPos> upperPartBlocks = new HashSet<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -depth; y <= radius * 2; ++y) {
                    BlockState state;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    boolean shouldCheck = false;
                    boolean isUpperPart = false;
                    if (y <= 0) {
                        double normalizedDepth = (double)(-y) / (double)depth;
                        double depthRadius = (double)radius * (1.0 - normalizedDepth * normalizedDepth);
                        if (horizontalDistance <= depthRadius) {
                            shouldCheck = true;
                        }
                    } else {
                        double edgeRadius = (double)radius * Math.max(0.0, 1.0 - (double)y / (double)(radius * 2));
                        if (horizontalDistance <= edgeRadius) {
                            shouldCheck = true;
                            isUpperPart = true;
                        }
                    }
                    if (!shouldCheck || WasteBlastGenerator.isWaterBlock(state = level.m_8055_(checkPos)) || WasteBlastGenerator.isAirBlock(state)) continue;
                    if (isUpperPart) {
                        upperPartBlocks.add(checkPos);
                    }
                    double distanceFromCenter = Math.sqrt(x * x + y * y + z * z);
                    int distanceKey = (int)Math.round(distanceFromCenter);
                    blocksToProcess.put(checkPos, distanceKey);
                }
            }
        }
        ArrayList<Map.Entry<BlockPos, Integer>> sortedBlocks = new ArrayList<Map.Entry<BlockPos, Integer>>(blocksToProcess.entrySet());
        sortedBlocks.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        HashSet<BlockPos> removedBlocks = new HashSet<BlockPos>();
        int blocksPerTick = Math.max(1, sortedBlocks.size() / 40);
        WasteBlastGenerator.processBlocksAnimated(level, sortedBlocks, blocksPerTick, 0, removedBlocks, upperPartBlocks, centerPos, sellafieldBlocks);
    }

    private static void processBlocksAnimated(ServerLevel level, List<Map.Entry<BlockPos, Integer>> sortedBlocks, int blocksPerTick, int currentIndex, Set<BlockPos> removedBlocks, Set<BlockPos> upperPartBlocks, BlockPos centerPos, Block[] sellafieldBlocks) {
        RandomSource random = level.f_46441_;
        if (currentIndex >= sortedBlocks.size()) {
            WasteBlastGenerator.generateCraterSurfaceInstant(level, removedBlocks, upperPartBlocks, sellafieldBlocks, random);
            return;
        }
        HashSet<BlockPos> protectedBlocks = new HashSet<BlockPos>();
        int endIndex = Math.min(currentIndex + blocksPerTick, sortedBlocks.size());
        for (int i = currentIndex; i < endIndex; ++i) {
            BlockPos pos = sortedBlocks.get(i).getKey();
            Block block = level.m_8055_(pos).m_60734_();
            int resistance = ExplosionResistanceRegistry.getResistance(block);
            if (resistance >= 15 || protectedBlocks.contains(pos)) {
                protectedBlocks.add(pos);
                continue;
            }
            int distance = sortedBlocks.get(i).getValue();
            float survivalChance = WasteBlastGenerator.calculateSurvivalChance(resistance, distance, centerPos.m_123333_((Vec3i)pos));
            if (random.m_188501_() < survivalChance) {
                protectedBlocks.add(pos);
                if (resistance < 6 || resistance >= 15) continue;
                WasteBlastGenerator.protectNearbyBlocks(pos, protectedBlocks, level, centerPos);
                continue;
            }
            level.m_7471_(pos, false);
            removedBlocks.add(pos);
        }
        int nextIndex = endIndex;
        if (level.m_7654_() != null) {
            level.m_7654_().m_6937_((Runnable)new TickTask(1, () -> WasteBlastGenerator.processBlocksAnimated(level, sortedBlocks, blocksPerTick, nextIndex, removedBlocks, upperPartBlocks, centerPos, sellafieldBlocks)));
        }
    }
}

