/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawndelay.forge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.respawndelay_common_forge.cmds.CommandRespawnall;
import com.natamus.respawndelay_common_forge.events.RespawningEvent;
import java.lang.invoke.MethodHandles;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeRespawningEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeRespawningEvent.class);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent e) {
        CommandRespawnall.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent.Pre e) {
        Player player = e.player();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        RespawningEvent.onPlayerTick((ServerLevel)level, (ServerPlayer)player);
    }

    @SubscribeEvent
    public static boolean onPlayerDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        Level level = entity.level();
        if (level.isClientSide()) {
            return false;
        }
        if (!(entity instanceof Player)) {
            return false;
        }
        return !RespawningEvent.onPlayerDeath((ServerPlayer)entity, e.getSource(), 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        RespawningEvent.onPlayerLogout(player.level(), player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        RespawningEvent.onPlayerLogin(player.level(), player);
    }
}

