/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawndelay.neoforge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.natamus.respawndelay_common_neoforge.cmds.CommandRespawnall;
import com.natamus.respawndelay_common_neoforge.events.RespawningEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class NeoForgeRespawningEvent {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent e) {
        CommandRespawnall.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        RespawningEvent.onPlayerTick((ServerLevel)level, (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (!RespawningEvent.onPlayerDeath((ServerPlayer)entity, e.getSource(), 0.0f)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        RespawningEvent.onPlayerLogout(player.level(), player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        RespawningEvent.onPlayerLogin(player.level(), player);
    }
}

