/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawndelay_common_forge.config;

import com.natamus.collective_common_forge.config.DuskConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ConfigHandler
extends DuskConfig {
    public static HashMap<String, List<String>> configMetaData = new HashMap();
    @DuskConfig.Entry
    public static boolean ignoreAdministratorPlayers = false;
    @DuskConfig.Entry
    public static boolean ignoreCreativePlayers = true;
    @DuskConfig.Entry
    public static boolean keepItemsOnDeath = false;
    @DuskConfig.Entry
    public static boolean dropItemsOnDeath = true;
    @DuskConfig.Entry
    public static boolean respawnAtWorldSpawn = true;
    @DuskConfig.Entry
    public static boolean respawnWhenPlayerLogsOut = true;
    @DuskConfig.Entry
    public static boolean respawnWhenPlayerLogsIn = true;
    @DuskConfig.Entry(min=-1.0, max=3600.0)
    public static int respawnDelayInSeconds = 10;
    @DuskConfig.Entry
    public static String onDeathMessage = "You died! Your gamemode has been set to spectator.";
    @DuskConfig.Entry
    public static String onRespawnMessage = "You respawned.";
    @DuskConfig.Entry
    public static String waitingForRespawnMessage = "You will respawn in <seconds_left> seconds.";
    @DuskConfig.Entry(min=-50.0, max=256.0)
    public static int lowestPossibleYCoordinate = -10;

    public static void initConfig() {
        configMetaData.put("ignoreAdministratorPlayers", Arrays.asList("If enabled, player operators/administrators will not be put in spectator mode on death."));
        configMetaData.put("ignoreCreativePlayers", Arrays.asList("If enabled, player in creative mode will not be put in spectator mode on death."));
        configMetaData.put("keepItemsOnDeath", Arrays.asList("If enabled, players will keep their items on death, and no drop event will be ran. This will also ignore the 'dropItemsOnDeath' config."));
        configMetaData.put("dropItemsOnDeath", Arrays.asList("If enabled, players will drop their items on death as normal vanilla behaviour."));
        configMetaData.put("respawnAtWorldSpawn", Arrays.asList("If enabled, players will be respawned at the world spawn point. If disabled, they'll respawn wherever they're spectating."));
        configMetaData.put("respawnWhenPlayerLogsOut", Arrays.asList("If enabled, players will respawn when they logout while waiting for a respawn. Prevents players from getting stuck in spectator mode."));
        configMetaData.put("respawnWhenPlayerLogsIn", Arrays.asList("If enabled, players will respawn when they log in and are still in spectator mode. Prevents players from getting stuck in spectator mode."));
        configMetaData.put("respawnDelayInSeconds", Arrays.asList("The delay in seconds after which a spectating player will respawn. A value of -1 makes players never respawn automatically. The '/respawnall' command can still be used."));
        configMetaData.put("onDeathMessage", Arrays.asList("The message which is sent to the player on death. Leave empty to disable."));
        configMetaData.put("onRespawnMessage", Arrays.asList("The message which is sent to players when they respawn. Leave empty to disable."));
        configMetaData.put("waitingForRespawnMessage", Arrays.asList("The message which is sent to players when they are waiting to be respawned. The text '<seconds_left>' will be replaced with the actual seconds left. Leave empty to disable."));
        configMetaData.put("lowestPossibleYCoordinate", Arrays.asList("When a player falls into the void, this determines the y position that's set after when a player enters spectator mode."));
        DuskConfig.init((String)"Respawn Delay", (String)"respawndelay", ConfigHandler.class);
    }
}

