/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawndelay_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.respawndelay_common_neoforge.config.ConfigHandler;
import com.natamus.respawndelay_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RespawningEvent {
    public static HashMap<Player, Date> death_times = new HashMap();

    public static void onPlayerTick(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        if (serverPlayer.tickCount % 20 != 0) {
            return;
        }
        if (!serverPlayer.isSpectator()) {
            return;
        }
        if (!death_times.containsKey(serverPlayer)) {
            return;
        }
        int respawndelay = ConfigHandler.respawnDelayInSeconds;
        if (respawndelay < 0) {
            return;
        }
        Date now = new Date();
        Date timedied = death_times.get(serverPlayer);
        long ms = now.getTime() - timedied.getTime();
        if (ms > (long)respawndelay * 1000L) {
            Util.respawnPlayer((Level)serverLevel, serverPlayer);
            return;
        }
        int seconds = respawndelay - (int)(ms / 1000L);
        String waitingmessage = ConfigHandler.waitingForRespawnMessage;
        waitingmessage = waitingmessage.replaceAll("<seconds_left>", "" + seconds);
        MessageFunctions.sendMessage((Player)serverPlayer, (String)waitingmessage, (ChatFormatting)ChatFormatting.GRAY);
    }

    public static boolean onPlayerDeath(ServerPlayer serverPlayer, DamageSource damageSource, float damageAmount) {
        if (ConfigHandler.ignoreAdministratorPlayers && serverPlayer.hasPermissions(2)) {
            return true;
        }
        if (ConfigHandler.ignoreCreativePlayers && serverPlayer.isCreative()) {
            return true;
        }
        ServerLevel serverLevel = serverPlayer.level();
        serverPlayer.setGameMode(GameType.SPECTATOR);
        serverPlayer.setHealth(20.0f);
        serverPlayer.getFoodData().setFoodLevel(20);
        serverPlayer.getFoodData().setSaturation(5.0f);
        serverPlayer.awardStat(Stats.DEATHS);
        serverPlayer.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH));
        serverPlayer.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
        serverPlayer.clearFire();
        Vec3 pvec = serverPlayer.position();
        if (pvec.y() < (double)ConfigHandler.lowestPossibleYCoordinate) {
            pvec = new Vec3(pvec.x(), (double)ConfigHandler.lowestPossibleYCoordinate, pvec.z());
            serverPlayer.setDeltaMovement(0.0, 0.0, 0.0);
            serverPlayer.teleportTo(pvec.x(), pvec.y(), pvec.z());
        }
        if (!ConfigHandler.keepItemsOnDeath) {
            ArrayList<ItemEntity> playerdrops = new ArrayList<ItemEntity>();
            Inventory inv = serverPlayer.getInventory();
            for (int i = 0; i < 36; ++i) {
                ItemStack slot = inv.getItem(i);
                if (slot.isEmpty()) continue;
                playerdrops.add(new ItemEntity((Level)serverLevel, pvec.x, pvec.y + 1.0, pvec.z, slot.copy()));
                slot.setCount(0);
            }
            for (ItemStack next : serverPlayer.getInventory().getNonEquipmentItems()) {
                if (next.isEmpty()) continue;
                playerdrops.add(new ItemEntity((Level)serverLevel, pvec.x, pvec.y + 1.0, pvec.z, next.copy()));
                next.setCount(0);
            }
            if (ConfigHandler.dropItemsOnDeath) {
                for (ItemEntity drop : playerdrops) {
                    serverLevel.addFreshEntity((Entity)drop);
                }
            }
        }
        Date now = new Date();
        death_times.put((Player)serverPlayer, now);
        MessageFunctions.sendMessage((Player)serverPlayer, (String)ConfigHandler.onDeathMessage, (ChatFormatting)ChatFormatting.DARK_RED);
        return false;
    }

    public static void onPlayerLogout(Level level, Player player) {
        if (level.isClientSide()) {
            return;
        }
        if (death_times.containsKey(player)) {
            Util.respawnPlayer(level, (ServerPlayer)player);
        }
    }

    public static void onPlayerLogin(Level level, Player player) {
        if (level.isClientSide()) {
            return;
        }
        if (player.isSpectator() && !death_times.containsKey(player)) {
            Util.respawnPlayer(level, (ServerPlayer)player);
        }
    }
}

